// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_multi_draw_instanced_base_vertex_base_instance.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/modules/webgl/webgl_multi_draw_instanced_base_vertex_base_instance.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8WebGLMultiDrawInstancedBaseVertexBaseInstance::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLMultiDrawInstancedBaseVertexBaseInstance::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLMultiDrawInstancedBaseVertexBaseInstance::InstallInterfaceTemplate,
    V8WebGLMultiDrawInstancedBaseVertexBaseInstance::InstallContextDependentProperties,
    "WebGLMultiDrawInstancedBaseVertexBaseInstance",
    nullptr,
    V8WebGLMultiDrawInstancedBaseVertexBaseInstance::kThisTag,
    V8WebGLMultiDrawInstancedBaseVertexBaseInstance::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLMultiDrawInstancedBaseVertexBaseInstance::wrapper_type_info_ =
    V8WebGLMultiDrawInstancedBaseVertexBaseInstance::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WebGLMultiDrawInstancedBaseVertexBaseInstance>::value,
    "WebGLMultiDrawInstancedBaseVertexBaseInstance inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_multi_draw_instanced_base_vertex_base_instance {

void MultiDrawArraysInstancedBaseInstanceWEBGLOperationNoAllocDirectCallArg10(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, v8::Local<v8::Value> v8_arg2_firsts_list, uint32_t v8_arg3_firsts_offset, v8::Local<v8::Value> v8_arg4_counts_list, uint32_t v8_arg5_counts_offset, v8::Local<v8::Value> v8_arg6_instance_counts_list, uint32_t v8_arg7_instance_counts_offset, v8::Local<v8::Value> v8_arg8_base_instances_list, uint32_t v8_arg9_base_instances_offset, int32_t v8_arg10_drawcount, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);




v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLMultiDrawInstancedBaseVertexBaseInstance* blink_receiver = V8WebGLMultiDrawInstancedBaseVertexBaseInstance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
ExceptionState exception_state(isolate);
auto&& arg2_firsts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_firsts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_firsts_offset = v8_arg3_firsts_offset;
auto&& arg4_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 3, v8_arg4_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_counts_offset = v8_arg5_counts_offset;
auto&& arg6_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 5, v8_arg6_instance_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_instance_counts_offset = v8_arg7_instance_counts_offset;
auto&& arg8_base_instances_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 7, v8_arg8_base_instances_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_base_instances_offset = v8_arg9_base_instances_offset;
auto&& arg10_drawcount = v8_arg10_drawcount;
blink_receiver->multiDrawArraysInstancedBaseInstanceWEBGL(arg1_mode, arg2_firsts_list, arg3_firsts_offset, arg4_counts_list, arg5_counts_offset, arg6_instance_counts_list, arg7_instance_counts_offset, arg8_base_instances_list, arg9_base_instances_offset, arg10_drawcount);
}

void MultiDrawArraysInstancedBaseInstanceWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLMultiDrawInstancedBaseVertexBaseInstance_multiDrawArraysInstancedBaseInstanceWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLMultiDrawInstancedBaseVertexBaseInstance.multiDrawArraysInstancedBaseInstanceWEBGL");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLMultiDrawInstancedBaseVertexBaseInstance* blink_receiver = V8WebGLMultiDrawInstancedBaseVertexBaseInstance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_firsts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_firsts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_instance_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_base_instances_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_base_instances_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_drawcount = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->multiDrawArraysInstancedBaseInstanceWEBGL(arg1_mode, arg2_firsts_list, arg3_firsts_offset, arg4_counts_list, arg5_counts_offset, arg6_instance_counts_list, arg7_instance_counts_offset, arg8_base_instances_list, arg9_base_instances_offset, arg10_drawcount);

}

void MultiDrawElementsInstancedBaseVertexBaseInstanceWEBGLOperationNoAllocDirectCallArg13(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, v8::Local<v8::Value> v8_arg2_counts_list, uint32_t v8_arg3_counts_offset, uint32_t v8_arg4_type, v8::Local<v8::Value> v8_arg5_offsets_list, uint32_t v8_arg6_offsets_offset, v8::Local<v8::Value> v8_arg7_instance_counts_list, uint32_t v8_arg8_instance_counts_offset, v8::Local<v8::Value> v8_arg9_base_vertices_list, uint32_t v8_arg10_base_vertices_offset, v8::Local<v8::Value> v8_arg11_base_instances_list, uint32_t v8_arg12_base_instances_offset, int32_t v8_arg13_drawcount, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);





v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLMultiDrawInstancedBaseVertexBaseInstance* blink_receiver = V8WebGLMultiDrawInstancedBaseVertexBaseInstance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
ExceptionState exception_state(isolate);
auto&& arg2_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_counts_offset = v8_arg3_counts_offset;
auto&& arg4_type = v8_arg4_type;
auto&& arg5_offsets_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 4, v8_arg5_offsets_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offsets_offset = v8_arg6_offsets_offset;
auto&& arg7_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 6, v8_arg7_instance_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_instance_counts_offset = v8_arg8_instance_counts_offset;
auto&& arg9_base_vertices_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 8, v8_arg9_base_vertices_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_base_vertices_offset = v8_arg10_base_vertices_offset;
auto&& arg11_base_instances_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 10, v8_arg11_base_instances_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg12_base_instances_offset = v8_arg12_base_instances_offset;
auto&& arg13_drawcount = v8_arg13_drawcount;
blink_receiver->multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL(arg1_mode, arg2_counts_list, arg3_counts_offset, arg4_type, arg5_offsets_list, arg6_offsets_offset, arg7_instance_counts_list, arg8_instance_counts_offset, arg9_base_vertices_list, arg10_base_vertices_offset, arg11_base_instances_list, arg12_base_instances_offset, arg13_drawcount);
}

void MultiDrawElementsInstancedBaseVertexBaseInstanceWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLMultiDrawInstancedBaseVertexBaseInstance_multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLMultiDrawInstancedBaseVertexBaseInstance.multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 13) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(13, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLMultiDrawInstancedBaseVertexBaseInstance* blink_receiver = V8WebGLMultiDrawInstancedBaseVertexBaseInstance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_offsets_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offsets_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_instance_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_base_vertices_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_base_vertices_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_base_instances_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg12_base_instances_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 11, info[11], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg13_drawcount = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 12, info[12], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL(arg1_mode, arg2_counts_list, arg3_counts_offset, arg4_type, arg5_offsets_list, arg6_offsets_offset, arg7_instance_counts_list, arg8_instance_counts_offset, arg9_base_vertices_list, arg10_base_vertices_offset, arg11_base_instances_list, arg12_base_instances_offset, arg13_drawcount);

}


}  // namespace v8_webgl_multi_draw_instanced_base_vertex_base_instance

using namespace v8_webgl_multi_draw_instanced_base_vertex_base_instance;

}  // namespace 

void V8WebGLMultiDrawInstancedBaseVertexBaseInstance::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLMultiDrawInstancedBaseVertexBaseInstance::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLMultiDrawInstancedBaseVertexBaseInstance::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;






{
  static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawArraysInstancedBaseInstanceWEBGL[] = {
v8::CFunctionBuilder().Fn(MultiDrawArraysInstancedBaseInstanceWEBGLOperationNoAllocDirectCallArg10).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawElementsInstancedBaseVertexBaseInstanceWEBGL[] = {
v8::CFunctionBuilder().Fn(MultiDrawElementsInstancedBaseVertexBaseInstanceWEBGLOperationNoAllocDirectCallArg13).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"multiDrawArraysInstancedBaseInstanceWEBGL", MultiDrawArraysInstancedBaseInstanceWEBGLOperationCallback, 10, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawArraysInstancedBaseInstanceWEBGL, std::size(kNoAllocDirectCallOverloadsOfMultiDrawArraysInstancedBaseInstanceWEBGL)}, 
{{"multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL", MultiDrawElementsInstancedBaseVertexBaseInstanceWEBGLOperationCallback, 13, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawElementsInstancedBaseVertexBaseInstanceWEBGL, std::size(kNoAllocDirectCallOverloadsOfMultiDrawElementsInstancedBaseVertexBaseInstanceWEBGL)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLMultiDrawInstancedBaseVertexBaseInstance", kOperationTable);
}


}


void V8WebGLMultiDrawInstancedBaseVertexBaseInstance::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}


}  // namespace blink
