// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_draw_buffers.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/modules/webgl/webgl_draw_buffers.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8WebGLDrawBuffers::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLDrawBuffers::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLDrawBuffers::InstallInterfaceTemplate,
    V8WebGLDrawBuffers::InstallContextDependentProperties,
    "WebGLDrawBuffers",
    nullptr,
    V8WebGLDrawBuffers::kThisTag,
    V8WebGLDrawBuffers::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLDrawBuffers::wrapper_type_info_ =
    V8WebGLDrawBuffers::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WebGLDrawBuffers>::value,
    "WebGLDrawBuffers inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_draw_buffers {

void DrawBuffersWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLDrawBuffers_drawBuffersWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLDrawBuffers.drawBuffersWEBGL");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLDrawBuffers* blink_receiver = V8WebGLDrawBuffers::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffers = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawBuffersWEBGL(std::move(arg1_buffers));

}


}  // namespace v8_webgl_draw_buffers

using namespace v8_webgl_draw_buffers;

}  // namespace 

void V8WebGLDrawBuffers::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLDrawBuffers::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLDrawBuffers::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;



v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"COLOR_ATTACHMENT0_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment0Webgl},
{"COLOR_ATTACHMENT1_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment1Webgl},
{"COLOR_ATTACHMENT2_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment2Webgl},
{"COLOR_ATTACHMENT3_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment3Webgl},
{"COLOR_ATTACHMENT4_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment4Webgl},
{"COLOR_ATTACHMENT5_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment5Webgl},
{"COLOR_ATTACHMENT6_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment6Webgl},
{"COLOR_ATTACHMENT7_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment7Webgl},
{"COLOR_ATTACHMENT8_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment8Webgl},
{"COLOR_ATTACHMENT9_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment9Webgl},
{"COLOR_ATTACHMENT10_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment10Webgl},
{"COLOR_ATTACHMENT11_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment11Webgl},
{"COLOR_ATTACHMENT12_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment12Webgl},
{"COLOR_ATTACHMENT13_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment13Webgl},
{"COLOR_ATTACHMENT14_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment14Webgl},
{"COLOR_ATTACHMENT15_WEBGL", V8WebGLDrawBuffers::Constant::kColorAttachment15Webgl},
{"DRAW_BUFFER0_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer0Webgl},
{"DRAW_BUFFER1_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer1Webgl},
{"DRAW_BUFFER2_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer2Webgl},
{"DRAW_BUFFER3_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer3Webgl},
{"DRAW_BUFFER4_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer4Webgl},
{"DRAW_BUFFER5_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer5Webgl},
{"DRAW_BUFFER6_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer6Webgl},
{"DRAW_BUFFER7_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer7Webgl},
{"DRAW_BUFFER8_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer8Webgl},
{"DRAW_BUFFER9_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer9Webgl},
{"DRAW_BUFFER10_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer10Webgl},
{"DRAW_BUFFER11_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer11Webgl},
{"DRAW_BUFFER12_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer12Webgl},
{"DRAW_BUFFER13_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer13Webgl},
{"DRAW_BUFFER14_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer14Webgl},
{"DRAW_BUFFER15_WEBGL", V8WebGLDrawBuffers::Constant::kDrawBuffer15Webgl},
{"MAX_COLOR_ATTACHMENTS_WEBGL", V8WebGLDrawBuffers::Constant::kMaxColorAttachmentsWebgl},
{"MAX_DRAW_BUFFERS_WEBGL", V8WebGLDrawBuffers::Constant::kMaxDrawBuffersWebgl},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}



{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"drawBuffersWEBGL", DrawBuffersWEBGLOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLDrawBuffers", kOperationTable);
}



}


void V8WebGLDrawBuffers::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}


}  // namespace blink
