// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_context_attributes.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"alpha",
"antialias",
"depth",
"desynchronized",
"failIfMajorPerformanceCaveat",
"powerPreference",
"premultipliedAlpha",
"preserveDrawingBuffer",
"stencil",
"xrCompatible",
};


}  // namespace 

WebGLContextAttributes* WebGLContextAttributes::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WebGLContextAttributes* dictionary = MakeGarbageCollected<WebGLContextAttributes>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WebGLContextAttributes";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WebGLContextAttributes::WebGLContextAttributes() {
  
}

 WebGLContextAttributes::WebGLContextAttributes(v8::Isolate* isolate) {
  
}





















































void WebGLContextAttributes::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void WebGLContextAttributes::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void WebGLContextAttributes::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAlpha()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_alpha_);
DCHECK(!values[0].IsEmpty());
}
if (hasAntialias()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_antialias_);
DCHECK(!values[1].IsEmpty());
}
if (hasDepth()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_depth_);
DCHECK(!values[2].IsEmpty());
}
if (hasDesynchronized()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_desynchronized_);
DCHECK(!values[3].IsEmpty());
}
if (hasFailIfMajorPerformanceCaveat()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_fail_if_major_performance_caveat_);
DCHECK(!values[4].IsEmpty());
}
if (hasPowerPreference()) {
  values[5] = ToV8Traits<V8WebGLPowerPreference>::ToV8(script_state, member_power_preference_);
DCHECK(!values[5].IsEmpty());
}
if (hasPremultipliedAlpha()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_premultiplied_alpha_);
DCHECK(!values[6].IsEmpty());
}
if (hasPreserveDrawingBuffer()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_preserve_drawing_buffer_);
DCHECK(!values[7].IsEmpty());
}
if (hasStencil()) {
  values[8] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_stencil_);
DCHECK(!values[8].IsEmpty());
}
if (RuntimeEnabledFeatures::WebXREnabled()) {
  if (hasXrCompatible()) {
  values[9] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_xr_compatible_);
DCHECK(!values[9].IsEmpty());
}
}
}

const void* WebGLContextAttributes::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> WebGLContextAttributes::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void WebGLContextAttributes::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WebGLContextAttributes";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("alpha");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_alpha_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("antialias");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_antialias_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_depth_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("desynchronized");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_desynchronized_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("failIfMajorPerformanceCaveat");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_fail_if_major_performance_caveat_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("powerPreference");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebGLPowerPreference, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_power_preference_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("premultipliedAlpha");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_premultiplied_alpha_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("preserveDrawingBuffer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_preserve_drawing_buffer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stencil");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_stencil_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebXREnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("xrCompatible");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_xr_compatible_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> WebGLContextAttributes::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
