// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_hash.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"protocols",
"serverCertificateHashes",
};


}  // namespace 

WebTransportOptions* WebTransportOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WebTransportOptions* dictionary = MakeGarbageCollected<WebTransportOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WebTransportOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WebTransportOptions::WebTransportOptions() {
  
}

 WebTransportOptions::WebTransportOptions(v8::Isolate* isolate) {
  
}



Vector<String> WebTransportOptions::getProtocolsOr(const Vector<String>& fallback_value) const {
  if (!hasProtocols()) {
  return fallback_value;
}
return member_protocols_;
}

Vector<String> WebTransportOptions::getProtocolsOr(Vector<String>&& fallback_value) const {
  if (!hasProtocols()) {
  return std::move(fallback_value);
}
return member_protocols_;
}

void WebTransportOptions::setProtocols(const Vector<String>& value) {
  member_protocols_ = value;
has_protocols_ = true;
}

void WebTransportOptions::setProtocols(Vector<String>&& value) {
  member_protocols_ = std::move(value);
has_protocols_ = true;
}




HeapVector<Member<WebTransportHash>> WebTransportOptions::getServerCertificateHashesOr(const HeapVector<Member<WebTransportHash>>& fallback_value) const {
  if (!hasServerCertificateHashes()) {
  return fallback_value;
}
return member_server_certificate_hashes_;
}

HeapVector<Member<WebTransportHash>> WebTransportOptions::getServerCertificateHashesOr(HeapVector<Member<WebTransportHash>>&& fallback_value) const {
  if (!hasServerCertificateHashes()) {
  return std::move(fallback_value);
}
return member_server_certificate_hashes_;
}

void WebTransportOptions::setServerCertificateHashes(const HeapVector<Member<WebTransportHash>>& value) {
  member_server_certificate_hashes_ = value;
has_server_certificate_hashes_ = true;
}

void WebTransportOptions::setServerCertificateHashes(HeapVector<Member<WebTransportHash>>&& value) {
  member_server_certificate_hashes_ = std::move(value);
has_server_certificate_hashes_ = true;
}




void WebTransportOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_server_certificate_hashes_);
bindings::InputDictionaryBase::Trace(visitor);
}

void WebTransportOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WebTransportOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::WebTransportApplicationProtocolEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("protocols");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_protocols_, member_protocols_, class_like_name, exception_state)) {
  return;
}
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::WebTransportCustomCertificatesEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("serverCertificateHashes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<WebTransportHash>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_server_certificate_hashes_, member_server_certificate_hashes_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> WebTransportOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
