// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_CONNECTION_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_CONNECTION_STATS_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class WebTransportDatagramStats;

class MODULES_EXPORT WebTransportConnectionStats : public bindings::DictionaryBase {
  
  public:
static WebTransportConnectionStats* Create() {
  return MakeGarbageCollected<WebTransportConnectionStats>();
}
static WebTransportConnectionStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebTransportConnectionStats>(isolate);
}
static WebTransportConnectionStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebTransportConnectionStats();
explicit  WebTransportConnectionStats(v8::Isolate* isolate);

bool hasDatagrams() const {
  return has_datagrams_;
}
WebTransportDatagramStats* datagrams() const {
  DCHECK(hasDatagrams());
return member_datagrams_.Get();
}
WebTransportDatagramStats* getDatagramsOr(WebTransportDatagramStats* fallback_value) const {
  if (!hasDatagrams()) {
  return fallback_value;
}
return member_datagrams_.Get();
}
void setDatagrams(WebTransportDatagramStats* value) {
  member_datagrams_ = value;
has_datagrams_ = true;
DCHECK(member_datagrams_);
}

bool hasEstimatedSendRate() const {
  return has_estimated_send_rate_;
}
const std::optional<uint64_t>& estimatedSendRate() const {
  DCHECK(hasEstimatedSendRate());
return member_estimated_send_rate_;
}
std::optional<uint64_t> getEstimatedSendRateOr(const std::optional<uint64_t>& fallback_value) const {
  if (!hasEstimatedSendRate()) {
  return fallback_value;
}
return member_estimated_send_rate_;
}
void setEstimatedSendRate(const std::optional<uint64_t>& value) {
  member_estimated_send_rate_ = value;
has_estimated_send_rate_ = true;
}
void setEstimatedSendRate(uint64_t value) {
  member_estimated_send_rate_ = value;
has_estimated_send_rate_ = true;
}

bool hasMinRtt() const {
  return has_min_rtt_;
}
double minRtt() const {
  DCHECK(hasMinRtt());
return member_min_rtt_;
}
double getMinRttOr(double fallback_value) const {
  if (!hasMinRtt()) {
  return fallback_value;
}
return member_min_rtt_;
}
void setMinRtt(double value) {
  member_min_rtt_ = value;
has_min_rtt_ = true;
}

bool hasRttVariation() const {
  return has_rtt_variation_;
}
double rttVariation() const {
  DCHECK(hasRttVariation());
return member_rtt_variation_;
}
double getRttVariationOr(double fallback_value) const {
  if (!hasRttVariation()) {
  return fallback_value;
}
return member_rtt_variation_;
}
void setRttVariation(double value) {
  member_rtt_variation_ = value;
has_rtt_variation_ = true;
}

bool hasSmoothedRtt() const {
  return has_smoothed_rtt_;
}
double smoothedRtt() const {
  DCHECK(hasSmoothedRtt());
return member_smoothed_rtt_;
}
double getSmoothedRttOr(double fallback_value) const {
  if (!hasSmoothedRtt()) {
  return fallback_value;
}
return member_smoothed_rtt_;
}
void setSmoothedRtt(double value) {
  member_smoothed_rtt_ = value;
has_smoothed_rtt_ = true;
}


// Obsolete accessor functions
bool hasEstimatedSendRateNonNull() const {
  return hasEstimatedSendRate() && estimatedSendRate().has_value();
}
uint64_t estimatedSendRateNonNull() const {
  DCHECK(hasEstimatedSendRateNonNull());
return estimatedSendRate().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_datagrams_ = false;
bool has_estimated_send_rate_ = false;
bool has_min_rtt_ = false;
bool has_rtt_variation_ = false;
bool has_smoothed_rtt_ = false;

Member<WebTransportDatagramStats> member_datagrams_;
std::optional<uint64_t> member_estimated_send_rate_;
double member_min_rtt_;
double member_rtt_variation_;
double member_smoothed_rtt_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_CONNECTION_STATS_H_
