// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_RANGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_RANGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebPrintingRange : public bindings::DictionaryBase {
  
  public:
static WebPrintingRange* Create() {
  return MakeGarbageCollected<WebPrintingRange>();
}
static WebPrintingRange* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrintingRange>(isolate);
}
static WebPrintingRange* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrintingRange();
explicit  WebPrintingRange(v8::Isolate* isolate);

bool hasFrom() const {
  return has_from_;
}
uint32_t from() const {
  DCHECK(hasFrom());
return member_from_;
}
uint32_t getFromOr(uint32_t fallback_value) const {
  if (!hasFrom()) {
  return fallback_value;
}
return member_from_;
}
void setFrom(uint32_t value) {
  member_from_ = value;
has_from_ = true;
}

bool hasTo() const {
  return has_to_;
}
uint32_t to() const {
  DCHECK(hasTo());
return member_to_;
}
uint32_t getToOr(uint32_t fallback_value) const {
  if (!hasTo()) {
  return fallback_value;
}
return member_to_;
}
void setTo(uint32_t value) {
  member_to_ = value;
has_to_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_from_ = false;
bool has_to_ = false;

uint32_t member_from_;
uint32_t member_to_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_RANGE_H_
