// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_job_template_attributes.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_media_collection_requested.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_resolution.h"
#include "third_party/blink/renderer/core/dom/abort_signal.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"copies",
"mediaCol",
"mediaSource",
"multipleDocumentHandling",
"orientationRequested",
"printColorMode",
"printQuality",
"printerResolution",
"sides",
"signal",
};


}  // namespace 

WebPrintJobTemplateAttributes* WebPrintJobTemplateAttributes::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WebPrintJobTemplateAttributes* dictionary = MakeGarbageCollected<WebPrintJobTemplateAttributes>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WebPrintJobTemplateAttributes";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WebPrintJobTemplateAttributes::WebPrintJobTemplateAttributes() {
  
}

 WebPrintJobTemplateAttributes::WebPrintJobTemplateAttributes(v8::Isolate* isolate) {
  
}

















String WebPrintJobTemplateAttributes::getMediaSourceOr(const String& fallback_value) const {
  if (!hasMediaSource()) {
  return fallback_value;
}
return member_media_source_;
}

String WebPrintJobTemplateAttributes::getMediaSourceOr(String&& fallback_value) const {
  if (!hasMediaSource()) {
  return std::move(fallback_value);
}
return member_media_source_;
}

void WebPrintJobTemplateAttributes::setMediaSource(const String& value) {
  member_media_source_ = value;
has_media_source_ = true;
}

void WebPrintJobTemplateAttributes::setMediaSource(String&& value) {
  member_media_source_ = std::move(value);
has_media_source_ = true;
}





















































void WebPrintJobTemplateAttributes::Trace(Visitor* visitor) const {
  visitor->Trace(member_media_col_);
visitor->Trace(member_printer_resolution_);
visitor->Trace(member_signal_);
bindings::InputDictionaryBase::Trace(visitor);
}

void WebPrintJobTemplateAttributes::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WebPrintJobTemplateAttributes";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("copies");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_copies_, member_copies_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaCol");
if (!bindings::GetDictionaryMemberFromV8Object<WebPrintingMediaCollectionRequested, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_media_col_, member_media_col_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaSource");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_media_source_, member_media_source_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("multipleDocumentHandling");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingMultipleDocumentHandling, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_multiple_document_handling_, member_multiple_document_handling_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("orientationRequested");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingOrientationRequested, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_orientation_requested_, member_orientation_requested_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printColorMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintColorMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_print_color_mode_, member_print_color_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printQuality");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintQuality, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_print_quality_, member_print_quality_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerResolution");
if (!bindings::GetDictionaryMemberFromV8Object<WebPrintingResolution, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_printer_resolution_, member_printer_resolution_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sides");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingSides, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_sides_, member_sides_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<AbortSignal, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_signal_, member_signal_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> WebPrintJobTemplateAttributes::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
