// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_alpha_option.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMRectInit;
class ExceptionState;

class MODULES_EXPORT VideoFrameInit : public bindings::InputDictionaryBase {
  
  public:
static VideoFrameInit* Create() {
  return MakeGarbageCollected<VideoFrameInit>();
}
static VideoFrameInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoFrameInit>(isolate);
}
static VideoFrameInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoFrameInit();
explicit  VideoFrameInit(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
V8AlphaOption alpha() const {
  return member_alpha_;
}
void setAlpha(V8AlphaOption value) {
  member_alpha_ = value;
}
void setAlpha(V8AlphaOption::Enum value) {
  member_alpha_ = V8AlphaOption(value);
}

bool hasDisplayHeight() const {
  return has_display_height_;
}
uint32_t displayHeight() const {
  DCHECK(hasDisplayHeight());
return member_display_height_;
}
uint32_t getDisplayHeightOr(uint32_t fallback_value) const {
  if (!hasDisplayHeight()) {
  return fallback_value;
}
return member_display_height_;
}
void setDisplayHeight(uint32_t value) {
  member_display_height_ = value;
has_display_height_ = true;
}

bool hasDisplayWidth() const {
  return has_display_width_;
}
uint32_t displayWidth() const {
  DCHECK(hasDisplayWidth());
return member_display_width_;
}
uint32_t getDisplayWidthOr(uint32_t fallback_value) const {
  if (!hasDisplayWidth()) {
  return fallback_value;
}
return member_display_width_;
}
void setDisplayWidth(uint32_t value) {
  member_display_width_ = value;
has_display_width_ = true;
}

bool hasDuration() const {
  return has_duration_;
}
uint64_t duration() const {
  DCHECK(hasDuration());
return member_duration_;
}
uint64_t getDurationOr(uint64_t fallback_value) const {
  if (!hasDuration()) {
  return fallback_value;
}
return member_duration_;
}
void setDuration(uint64_t value) {
  member_duration_ = value;
has_duration_ = true;
}

bool hasFlip() const {
  return true;
}
bool flip() const {
  return member_flip_;
}
void setFlip(bool value) {
  member_flip_ = value;
}

bool hasRotation() const {
  return true;
}
double rotation() const {
  return member_rotation_;
}
void setRotation(double value) {
  member_rotation_ = value;
}

bool hasTimestamp() const {
  return has_timestamp_;
}
int64_t timestamp() const {
  DCHECK(hasTimestamp());
return member_timestamp_;
}
int64_t getTimestampOr(int64_t fallback_value) const {
  if (!hasTimestamp()) {
  return fallback_value;
}
return member_timestamp_;
}
void setTimestamp(int64_t value) {
  member_timestamp_ = value;
has_timestamp_ = true;
}

bool hasVisibleRect() const {
  return has_visible_rect_;
}
DOMRectInit* visibleRect() const {
  DCHECK(hasVisibleRect());
return member_visible_rect_.Get();
}
DOMRectInit* getVisibleRectOr(DOMRectInit* fallback_value) const {
  if (!hasVisibleRect()) {
  return fallback_value;
}
return member_visible_rect_.Get();
}
void setVisibleRect(DOMRectInit* value) {
  member_visible_rect_ = value;
has_visible_rect_ = true;
DCHECK(member_visible_rect_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_display_height_ = false;
bool has_display_width_ = false;
bool has_duration_ = false;
bool has_timestamp_ = false;
bool has_visible_rect_ = false;

V8AlphaOption member_alpha_{V8AlphaOption::Enum::kKeep};
uint32_t member_display_height_;
uint32_t member_display_width_;
uint64_t member_duration_;
bool member_flip_{false};
double member_rotation_{0};
int64_t member_timestamp_;
Member<DOMRectInit> member_visible_rect_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_INIT_H_
