// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_CALLBACK_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_CALLBACK_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT VideoFrameCallbackMetadata : public bindings::DictionaryBase {
  
  public:
static VideoFrameCallbackMetadata* Create() {
  return MakeGarbageCollected<VideoFrameCallbackMetadata>();
}
static VideoFrameCallbackMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoFrameCallbackMetadata>(isolate);
}
static VideoFrameCallbackMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoFrameCallbackMetadata();
explicit  VideoFrameCallbackMetadata(v8::Isolate* isolate);

bool hasCaptureTime() const {
  return has_capture_time_;
}
double captureTime() const {
  DCHECK(hasCaptureTime());
return member_capture_time_;
}
double getCaptureTimeOr(double fallback_value) const {
  if (!hasCaptureTime()) {
  return fallback_value;
}
return member_capture_time_;
}
void setCaptureTime(double value) {
  member_capture_time_ = value;
has_capture_time_ = true;
}

bool hasExpectedDisplayTime() const {
  return true;
}
double expectedDisplayTime() const {
  return member_expected_display_time_;
}
void setExpectedDisplayTime(double value) {
  member_expected_display_time_ = value;
}

bool hasHeight() const {
  return true;
}
uint32_t height() const {
  return member_height_;
}
void setHeight(uint32_t value) {
  member_height_ = value;
}

bool hasMediaTime() const {
  return true;
}
double mediaTime() const {
  return member_media_time_;
}
void setMediaTime(double value) {
  member_media_time_ = value;
}

bool hasPresentationTime() const {
  return true;
}
double presentationTime() const {
  return member_presentation_time_;
}
void setPresentationTime(double value) {
  member_presentation_time_ = value;
}

bool hasPresentedFrames() const {
  return true;
}
uint32_t presentedFrames() const {
  return member_presented_frames_;
}
void setPresentedFrames(uint32_t value) {
  member_presented_frames_ = value;
}

bool hasProcessingDuration() const {
  return has_processing_duration_;
}
double processingDuration() const {
  DCHECK(hasProcessingDuration());
return member_processing_duration_;
}
double getProcessingDurationOr(double fallback_value) const {
  if (!hasProcessingDuration()) {
  return fallback_value;
}
return member_processing_duration_;
}
void setProcessingDuration(double value) {
  member_processing_duration_ = value;
has_processing_duration_ = true;
}

bool hasReceiveTime() const {
  return has_receive_time_;
}
double receiveTime() const {
  DCHECK(hasReceiveTime());
return member_receive_time_;
}
double getReceiveTimeOr(double fallback_value) const {
  if (!hasReceiveTime()) {
  return fallback_value;
}
return member_receive_time_;
}
void setReceiveTime(double value) {
  member_receive_time_ = value;
has_receive_time_ = true;
}

bool hasRtpTimestamp() const {
  return has_rtp_timestamp_;
}
uint32_t rtpTimestamp() const {
  DCHECK(hasRtpTimestamp());
return member_rtp_timestamp_;
}
uint32_t getRtpTimestampOr(uint32_t fallback_value) const {
  if (!hasRtpTimestamp()) {
  return fallback_value;
}
return member_rtp_timestamp_;
}
void setRtpTimestamp(uint32_t value) {
  member_rtp_timestamp_ = value;
has_rtp_timestamp_ = true;
}

bool hasWidth() const {
  return true;
}
uint32_t width() const {
  return member_width_;
}
void setWidth(uint32_t value) {
  member_width_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_capture_time_ = false;
bool has_processing_duration_ = false;
bool has_receive_time_ = false;
bool has_rtp_timestamp_ = false;

double member_capture_time_;
double member_expected_display_time_;
uint32_t member_height_;
double member_media_time_;
double member_presentation_time_;
uint32_t member_presented_frames_;
double member_processing_duration_;
double member_receive_time_;
uint32_t member_rtp_timestamp_;
uint32_t member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_CALLBACK_METADATA_H_
