// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_DECODER_SUPPORT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_DECODER_SUPPORT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class VideoDecoderConfig;

class MODULES_EXPORT VideoDecoderSupport : public bindings::DictionaryBase {
  
  public:
static VideoDecoderSupport* Create() {
  return MakeGarbageCollected<VideoDecoderSupport>();
}
static VideoDecoderSupport* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoDecoderSupport>(isolate);
}
static VideoDecoderSupport* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoDecoderSupport();
explicit  VideoDecoderSupport(v8::Isolate* isolate);

bool hasConfig() const {
  return true;
}
VideoDecoderConfig* config() const {
  return member_config_.Get();
}
void setConfig(VideoDecoderConfig* value) {
  member_config_ = value;
DCHECK(member_config_);
}

bool hasSupported() const {
  return true;
}
bool supported() const {
  return member_supported_;
}
void setSupported(bool value) {
  member_supported_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<VideoDecoderConfig> member_config_;
bool member_supported_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_DECODER_SUPPORT_H_
