// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_decoder_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_color_space_init.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"codec",
"codedHeight",
"codedWidth",
"colorSpace",
"description",
"displayAspectHeight",
"displayAspectWidth",
"encryptionScheme",
"flip",
"hardwareAcceleration",
"optimizeForLatency",
"rotation",
};


}  // namespace 

VideoDecoderConfig* VideoDecoderConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoDecoderConfig* dictionary = MakeGarbageCollected<VideoDecoderConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoDecoderConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoDecoderConfig::VideoDecoderConfig() {
  
}

 VideoDecoderConfig::VideoDecoderConfig(v8::Isolate* isolate) {
  
}



void VideoDecoderConfig::setCodec(const String& value) {
  member_codec_ = value;
}

void VideoDecoderConfig::setCodec(String&& value) {
  member_codec_ = std::move(value);
}














































String VideoDecoderConfig::getEncryptionSchemeOr(const String& fallback_value) const {
  if (!hasEncryptionScheme()) {
  return fallback_value;
}
return member_encryption_scheme_;
}

String VideoDecoderConfig::getEncryptionSchemeOr(String&& fallback_value) const {
  if (!hasEncryptionScheme()) {
  return std::move(fallback_value);
}
return member_encryption_scheme_;
}

void VideoDecoderConfig::setEncryptionScheme(const String& value) {
  member_encryption_scheme_ = value;
has_encryption_scheme_ = true;
}

void VideoDecoderConfig::setEncryptionScheme(String&& value) {
  member_encryption_scheme_ = std::move(value);
has_encryption_scheme_ = true;
}


























void VideoDecoderConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_color_space_);
visitor->Trace(member_description_);
bindings::DictionaryBase::Trace(visitor);
}

void VideoDecoderConfig::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void VideoDecoderConfig::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCodec()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_codec_);
DCHECK(!values[0].IsEmpty());
}
if (hasCodedHeight()) {
  values[1] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_coded_height_);
DCHECK(!values[1].IsEmpty());
}
if (hasCodedWidth()) {
  values[2] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_coded_width_);
DCHECK(!values[2].IsEmpty());
}
if (hasColorSpace()) {
  values[3] = ToV8Traits<VideoColorSpaceInit>::ToV8(script_state, member_color_space_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasDescription()) {
  values[4] = ToV8Traits<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared>::ToV8(script_state, member_description_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasDisplayAspectHeight()) {
  values[5] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_display_aspect_height_);
DCHECK(!values[5].IsEmpty());
}
if (hasDisplayAspectWidth()) {
  values[6] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_display_aspect_width_);
DCHECK(!values[6].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaSourceExtensionsForWebCodecsEnabled(execution_context)) {
  if (hasEncryptionScheme()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_encryption_scheme_);
DCHECK(!values[7].IsEmpty());
}
}
if (RuntimeEnabledFeatures::WebCodecsOrientationEnabled()) {
  if (hasFlip()) {
  values[8] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_flip_);
DCHECK(!values[8].IsEmpty());
}
}
if (hasHardwareAcceleration()) {
  values[9] = ToV8Traits<V8HardwarePreference>::ToV8(script_state, member_hardware_acceleration_);
DCHECK(!values[9].IsEmpty());
}
if (hasOptimizeForLatency()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_optimize_for_latency_);
DCHECK(!values[10].IsEmpty());
}
if (RuntimeEnabledFeatures::WebCodecsOrientationEnabled()) {
  if (hasRotation()) {
  values[11] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_rotation_);
DCHECK(!values[11].IsEmpty());
}
}
}

const void* VideoDecoderConfig::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> VideoDecoderConfig::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void VideoDecoderConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoDecoderConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("codec");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_codec_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("codedHeight");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_coded_height_, member_coded_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("codedWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_coded_width_, member_coded_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorSpace");
if (!bindings::GetDictionaryMemberFromV8Object<VideoColorSpaceInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_color_space_, member_color_space_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("description");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_description_, member_description_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displayAspectHeight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_display_aspect_height_, member_display_aspect_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displayAspectWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_display_aspect_width_, member_display_aspect_width_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaSourceExtensionsForWebCodecsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("encryptionScheme");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_encryption_scheme_, member_encryption_scheme_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::WebCodecsOrientationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("flip");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_flip_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("hardwareAcceleration");
if (!bindings::GetDictionaryMemberFromV8Object<V8HardwarePreference, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_hardware_acceleration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("optimizeForLatency");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_optimize_for_latency_, member_optimize_for_latency_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebCodecsOrientationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("rotation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), fallback_presence_var, member_rotation_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> VideoDecoderConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
