// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USB_CONTROL_TRANSFER_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USB_CONTROL_TRANSFER_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_recipient.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_request_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT USBControlTransferParameters : public bindings::InputDictionaryBase {
  
  public:
static USBControlTransferParameters* Create() {
  return MakeGarbageCollected<USBControlTransferParameters>();
}
static USBControlTransferParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<USBControlTransferParameters>(isolate);
}
static USBControlTransferParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  USBControlTransferParameters();
explicit  USBControlTransferParameters(v8::Isolate* isolate);

bool hasIndex() const {
  return true;
}
uint16_t index() const {
  return member_index_;
}
void setIndex(uint16_t value) {
  member_index_ = value;
}

bool hasRecipient() const {
  return true;
}
V8USBRecipient recipient() const {
  return member_recipient_;
}
void setRecipient(V8USBRecipient value) {
  member_recipient_ = value;
}
void setRecipient(V8USBRecipient::Enum value) {
  member_recipient_ = V8USBRecipient(value);
}

bool hasRequest() const {
  return true;
}
uint8_t request() const {
  return member_request_;
}
void setRequest(uint8_t value) {
  member_request_ = value;
}

bool hasRequestType() const {
  return true;
}
V8USBRequestType requestType() const {
  return member_request_type_;
}
void setRequestType(V8USBRequestType value) {
  member_request_type_ = value;
}
void setRequestType(V8USBRequestType::Enum value) {
  member_request_type_ = V8USBRequestType(value);
}

bool hasValue() const {
  return true;
}
uint16_t value() const {
  return member_value_;
}
void setValue(uint16_t value) {
  member_value_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint16_t member_index_;
V8USBRecipient member_recipient_{static_cast<V8USBRecipient::Enum>(0)};
uint8_t member_request_;
V8USBRequestType member_request_type_{static_cast<V8USBRequestType::Enum>(0)};
uint16_t member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USB_CONTROL_TRANSFER_PARAMETERS_H_
