// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_UNSIGNEDLONG_WEBPRINTINGRANGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_UNSIGNEDLONG_WEBPRINTINGRANGE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ScriptState;
class WebPrintingRange;

class MODULES_EXPORT V8UnionUnsignedLongOrWebPrintingRange final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kUnsignedLong, kWebPrintingRange
};

static V8UnionUnsignedLongOrWebPrintingRange* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionUnsignedLongOrWebPrintingRange(uint32_t value) : content_type_(ContentType::kUnsignedLong), member_unsigned_long_(value) {
  
}
explicit  V8UnionUnsignedLongOrWebPrintingRange(WebPrintingRange* value) : content_type_(ContentType::kWebPrintingRange), member_web_printing_range_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsUnsignedLong() const {
  return content_type_ == ContentType::kUnsignedLong;
}
uint32_t GetAsUnsignedLong() const {
  DCHECK_EQ(content_type_, ContentType::kUnsignedLong);
return member_unsigned_long_;
}
void Set(uint32_t value) {
  Clear();
member_unsigned_long_ = value;
content_type_ = ContentType::kUnsignedLong;
}

bool IsWebPrintingRange() const {
  return content_type_ == ContentType::kWebPrintingRange;
}
WebPrintingRange* GetAsWebPrintingRange() const {
  DCHECK_EQ(content_type_, ContentType::kWebPrintingRange);
return member_web_printing_range_.Get();
}
void Set(WebPrintingRange* value) {
  DCHECK(value);
Clear();
member_web_printing_range_ = value;
content_type_ = ContentType::kWebPrintingRange;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(WebPrintingRange or unsigned long)";
}

ContentType content_type_;

uint32_t member_unsigned_long_;
Member<WebPrintingRange> member_web_printing_range_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_UNSIGNEDLONG_WEBPRINTINGRANGE_H_
