// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ROUTERRULE_ROUTERRULESEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ROUTERRULE_ROUTERRULESEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RouterRule;
class ScriptState;

class MODULES_EXPORT V8UnionRouterRuleOrRouterRuleSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kRouterRule, kRouterRuleSequence
};

static V8UnionRouterRuleOrRouterRuleSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionRouterRuleOrRouterRuleSequence(RouterRule* value) : content_type_(ContentType::kRouterRule), member_router_rule_(value) {
  DCHECK(value);
}
explicit  V8UnionRouterRuleOrRouterRuleSequence(const HeapVector<Member<RouterRule>>& value);
explicit  V8UnionRouterRuleOrRouterRuleSequence(HeapVector<Member<RouterRule>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsRouterRule() const {
  return content_type_ == ContentType::kRouterRule;
}
RouterRule* GetAsRouterRule() const {
  DCHECK_EQ(content_type_, ContentType::kRouterRule);
return member_router_rule_.Get();
}
void Set(RouterRule* value) {
  DCHECK(value);
Clear();
member_router_rule_ = value;
content_type_ = ContentType::kRouterRule;
}

bool IsRouterRuleSequence() const {
  return content_type_ == ContentType::kRouterRuleSequence;
}
const HeapVector<Member<RouterRule>>& GetAsRouterRuleSequence() const {
  DCHECK_EQ(content_type_, ContentType::kRouterRuleSequence);
return member_router_rule_sequence_;
}
void Set(const HeapVector<Member<RouterRule>>& value);
void Set(HeapVector<Member<RouterRule>>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(RouterRule or sequence<RouterRule>)";
}

ContentType content_type_;

Member<RouterRule> member_router_rule_;
HeapVector<Member<RouterRule>> member_router_rule_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ROUTERRULE_ROUTERRULESEQUENCE_H_
