// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_offscreen_rendering_context.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_bitmap_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_offscreen_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_webgl2renderingcontext_webglrenderingcontext.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context_webgpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context_webgpu.h"
#include "third_party/blink/renderer/modules/canvas/imagebitmap/image_bitmap_rendering_context.h"
#include "third_party/blink/renderer/modules/canvas/offscreencanvas2d/offscreen_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/modules/webgl/webgl2_rendering_context.h"
#include "third_party/blink/renderer/modules/webgl/webgl2_rendering_context_webgpu.h"
#include "third_party/blink/renderer/modules/webgl/webgl_rendering_context.h"
#include "third_party/blink/renderer/modules/webgl/webgl_rendering_context_webgpu.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_canvas_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8OffscreenRenderingContext* V8OffscreenRenderingContext::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8WebGLRenderingContextWebGPU::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
if (V8WebGLRenderingContext::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8WebGLRenderingContext::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
if (V8WebGL2RenderingContextWebGPU::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8WebGL2RenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
if (V8WebGL2RenderingContext::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
if (V8OffscreenCanvasRenderingContext2D::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
if (V8ImageBitmapRenderingContext::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ImageBitmapRenderingContext::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
if (V8GPUCanvasContext::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUCanvasContext::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8OffscreenRenderingContext>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}

























V8UnionWebGL2RenderingContextOrWebGLRenderingContext* V8OffscreenRenderingContext::GetAsV8UnionWebGL2RenderingContextOrWebGLRenderingContext() const {
  switch (content_type_) {
  case ContentType::kWebGL2RenderingContext: {
    return MakeGarbageCollected<V8UnionWebGL2RenderingContextOrWebGLRenderingContext>(GetAsWebGL2RenderingContext());
  }
  case ContentType::kWebGLRenderingContext: {
    return MakeGarbageCollected<V8UnionWebGL2RenderingContextOrWebGLRenderingContext>(GetAsWebGLRenderingContext());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8OffscreenRenderingContext::Set(const V8UnionWebGL2RenderingContextOrWebGLRenderingContext* value) {
  switch (value->GetContentType()) {
  case V8UnionWebGL2RenderingContextOrWebGLRenderingContext::ContentType::kWebGL2RenderingContext: {
    Set(value->GetAsWebGL2RenderingContext());
    break;
  }
  case V8UnionWebGL2RenderingContextOrWebGLRenderingContext::ContentType::kWebGLRenderingContext: {
    Set(value->GetAsWebGLRenderingContext());
    break;
  }
}
}




v8::Local<v8::Value> V8OffscreenRenderingContext::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kGPUCanvasContext: {
    return ToV8Traits<GPUCanvasContext>::ToV8(script_state, member_gpu_canvas_context_.Get());
  }
  case ContentType::kImageBitmapRenderingContext: {
    return ToV8Traits<ImageBitmapRenderingContext>::ToV8(script_state, member_image_bitmap_rendering_context_.Get());
  }
  case ContentType::kOffscreenCanvasRenderingContext2D: {
    return ToV8Traits<OffscreenCanvasRenderingContext2D>::ToV8(script_state, member_offscreen_canvas_rendering_context_2d_.Get());
  }
  case ContentType::kWebGL2RenderingContext: {
    return ToV8Traits<WebGL2RenderingContext>::ToV8(script_state, member_webgl2_rendering_context_.Get());
  }
  case ContentType::kWebGL2RenderingContextWebGPU: {
    return ToV8Traits<WebGL2RenderingContextWebGPU>::ToV8(script_state, member_webgl2_rendering_context_webgpu_.Get());
  }
  case ContentType::kWebGLRenderingContext: {
    return ToV8Traits<WebGLRenderingContext>::ToV8(script_state, member_webgl_rendering_context_.Get());
  }
  case ContentType::kWebGLRenderingContextWebGPU: {
    return ToV8Traits<WebGLRenderingContextWebGPU>::ToV8(script_state, member_webgl_rendering_context_webgpu_.Get());
  }
}

NOTREACHED();
}

void V8OffscreenRenderingContext::Trace(Visitor* visitor) const {
  visitor->Trace(member_gpu_canvas_context_);
visitor->Trace(member_image_bitmap_rendering_context_);
visitor->Trace(member_offscreen_canvas_rendering_context_2d_);
visitor->Trace(member_webgl2_rendering_context_);
visitor->Trace(member_webgl2_rendering_context_webgpu_);
visitor->Trace(member_webgl_rendering_context_);
visitor->Trace(member_webgl_rendering_context_webgpu_);
bindings::UnionBase::Trace(visitor);
}

void V8OffscreenRenderingContext::Clear() {
  member_gpu_canvas_context_.Clear();
member_image_bitmap_rendering_context_.Clear();
member_offscreen_canvas_rendering_context_2d_.Clear();
member_webgl2_rendering_context_.Clear();
member_webgl2_rendering_context_webgpu_.Clear();
member_webgl_rendering_context_.Clear();
member_webgl_rendering_context_webgpu_.Clear();
}



}  // namespace blink
