// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINDOMSTRINGPARAMETERS_STRING_STRINGSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINDOMSTRINGPARAMETERS_STRING_STRINGSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ConstrainDOMStringParameters;
class ExceptionState;
class ScriptState;
class V8UnionStringOrStringSequence;

class MODULES_EXPORT V8UnionConstrainDOMStringParametersOrStringOrStringSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kConstrainDOMStringParameters, kString, kStringSequence
};

static V8UnionConstrainDOMStringParametersOrStringOrStringSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionConstrainDOMStringParametersOrStringOrStringSequence(ConstrainDOMStringParameters* value) : content_type_(ContentType::kConstrainDOMStringParameters), member_constrain_dom_string_parameters_(value) {
  DCHECK(value);
}
explicit  V8UnionConstrainDOMStringParametersOrStringOrStringSequence(const String& value);
explicit  V8UnionConstrainDOMStringParametersOrStringOrStringSequence(String&& value);
explicit  V8UnionConstrainDOMStringParametersOrStringOrStringSequence(const Vector<String>& value);
explicit  V8UnionConstrainDOMStringParametersOrStringOrStringSequence(Vector<String>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsConstrainDOMStringParameters() const {
  return content_type_ == ContentType::kConstrainDOMStringParameters;
}
ConstrainDOMStringParameters* GetAsConstrainDOMStringParameters() const {
  DCHECK_EQ(content_type_, ContentType::kConstrainDOMStringParameters);
return member_constrain_dom_string_parameters_.Get();
}
void Set(ConstrainDOMStringParameters* value) {
  DCHECK(value);
Clear();
member_constrain_dom_string_parameters_ = value;
content_type_ = ContentType::kConstrainDOMStringParameters;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsStringSequence() const {
  return content_type_ == ContentType::kStringSequence;
}
const Vector<String>& GetAsStringSequence() const {
  DCHECK_EQ(content_type_, ContentType::kStringSequence);
return member_string_sequence_;
}
void Set(const Vector<String>& value);
void Set(Vector<String>&& value);

bool IsV8UnionStringOrStringSequence() const {
  return content_type_ == ContentType::kString || content_type_ == ContentType::kStringSequence;
}
V8UnionStringOrStringSequence* GetAsV8UnionStringOrStringSequence() const;
void Set(const V8UnionStringOrStringSequence* value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ConstrainDOMStringParameters or DOMString or sequence<DOMString>)";
}

ContentType content_type_;

Member<ConstrainDOMStringParameters> member_constrain_dom_string_parameters_;
String member_string_;
Vector<String> member_string_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINDOMSTRINGPARAMETERS_STRING_STRINGSEQUENCE_H_
