// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_mediatrackconstraints.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_constraints.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionBooleanOrMediaTrackConstraints* V8UnionBooleanOrMediaTrackConstraints::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = MediaTrackConstraints::Create(isolate);
return MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<MediaTrackConstraints>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(blink_value);
}
if (v8_value->IsBoolean()) {
  auto&& blink_value = v8_value.As<v8::Boolean>()->Value();
return MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(blink_value);
}
}










void V8UnionBooleanOrMediaTrackConstraints::Trace(Visitor* visitor) const {
  visitor->Trace(member_media_track_constraints_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionBooleanOrMediaTrackConstraints::Clear() {
  member_boolean_ = false;
member_media_track_constraints_.Clear();
}



}  // namespace blink
