// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_constraindoublerange_double.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_double_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_constraindoublerange_double.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionBooleanOrConstrainDoubleRangeOrDouble* V8UnionBooleanOrConstrainDoubleRangeOrDouble::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = ConstrainDoubleRange::Create(isolate);
return MakeGarbageCollected<V8UnionBooleanOrConstrainDoubleRangeOrDouble>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<ConstrainDoubleRange>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrConstrainDoubleRangeOrDouble>(blink_value);
}
if (v8_value->IsBoolean()) {
  auto&& blink_value = v8_value.As<v8::Boolean>()->Value();
return MakeGarbageCollected<V8UnionBooleanOrConstrainDoubleRangeOrDouble>(blink_value);
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrConstrainDoubleRangeOrDouble>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrConstrainDoubleRangeOrDouble>(blink_value);
}
}













V8UnionConstrainDoubleRangeOrDouble* V8UnionBooleanOrConstrainDoubleRangeOrDouble::GetAsV8UnionConstrainDoubleRangeOrDouble() const {
  switch (content_type_) {
  case ContentType::kConstrainDoubleRange: {
    return MakeGarbageCollected<V8UnionConstrainDoubleRangeOrDouble>(GetAsConstrainDoubleRange());
  }
  case ContentType::kDouble: {
    return MakeGarbageCollected<V8UnionConstrainDoubleRangeOrDouble>(GetAsDouble());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionBooleanOrConstrainDoubleRangeOrDouble::Set(const V8UnionConstrainDoubleRangeOrDouble* value) {
  switch (value->GetContentType()) {
  case V8UnionConstrainDoubleRangeOrDouble::ContentType::kConstrainDoubleRange: {
    Set(value->GetAsConstrainDoubleRange());
    break;
  }
  case V8UnionConstrainDoubleRangeOrDouble::ContentType::kDouble: {
    Set(value->GetAsDouble());
    break;
  }
}
}




v8::Local<v8::Value> V8UnionBooleanOrConstrainDoubleRangeOrDouble::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kBoolean: {
    return ToV8Traits<IDLBoolean>::ToV8(script_state, member_boolean_);
  }
  case ContentType::kConstrainDoubleRange: {
    return ToV8Traits<ConstrainDoubleRange>::ToV8(script_state, member_constrain_double_range_.Get());
  }
  case ContentType::kDouble: {
    return ToV8Traits<IDLDouble>::ToV8(script_state, member_double_);
  }
}

NOTREACHED();
}

void V8UnionBooleanOrConstrainDoubleRangeOrDouble::Trace(Visitor* visitor) const {
  visitor->Trace(member_constrain_double_range_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionBooleanOrConstrainDoubleRangeOrDouble::Clear() {
  member_boolean_ = false;
member_constrain_double_range_.Clear();
member_double_ = 0;
}



}  // namespace blink
