// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOCONTEXTLATENCYCATEGORY_DOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOCONTEXTLATENCYCATEGORY_DOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_context_latency_category.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"

namespace blink {

class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionAudioContextLatencyCategoryOrDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAudioContextLatencyCategory, kDouble
};

static V8UnionAudioContextLatencyCategoryOrDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAudioContextLatencyCategoryOrDouble(V8AudioContextLatencyCategory value) : content_type_(ContentType::kAudioContextLatencyCategory), member_audio_context_latency_category_(value) {
  
}
explicit  V8UnionAudioContextLatencyCategoryOrDouble(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAudioContextLatencyCategory() const {
  return content_type_ == ContentType::kAudioContextLatencyCategory;
}
V8AudioContextLatencyCategory GetAsAudioContextLatencyCategory() const {
  DCHECK_EQ(content_type_, ContentType::kAudioContextLatencyCategory);
return member_audio_context_latency_category_;
}
void Set(V8AudioContextLatencyCategory value) {
  Clear();
member_audio_context_latency_category_ = value;
content_type_ = ContentType::kAudioContextLatencyCategory;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AudioContextLatencyCategory or double)";
}

ContentType content_type_;

V8AudioContextLatencyCategory member_audio_context_latency_category_{static_cast<V8AudioContextLatencyCategory::Enum>(0)};
double member_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOCONTEXTLATENCYCATEGORY_DOUBLE_H_
