// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUMMARIZER_CREATE_CORE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUMMARIZER_CREATE_CORE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_summarizer_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_summarizer_length.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_summarizer_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SummarizerCreateCoreOptions : public bindings::InputDictionaryBase {
  
  public:
static SummarizerCreateCoreOptions* Create() {
  return MakeGarbageCollected<SummarizerCreateCoreOptions>();
}
static SummarizerCreateCoreOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SummarizerCreateCoreOptions>(isolate);
}
static SummarizerCreateCoreOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SummarizerCreateCoreOptions();
explicit  SummarizerCreateCoreOptions(v8::Isolate* isolate);

bool hasExpectedContextLanguages() const {
  return has_expected_context_languages_;
}
const Vector<String>& expectedContextLanguages() const {
  DCHECK(hasExpectedContextLanguages());
return member_expected_context_languages_;
}
Vector<String> getExpectedContextLanguagesOr(const Vector<String>& fallback_value) const;
Vector<String> getExpectedContextLanguagesOr(Vector<String>&& fallback_value) const;
void setExpectedContextLanguages(const Vector<String>& value);
void setExpectedContextLanguages(Vector<String>&& value);

bool hasExpectedInputLanguages() const {
  return has_expected_input_languages_;
}
const Vector<String>& expectedInputLanguages() const {
  DCHECK(hasExpectedInputLanguages());
return member_expected_input_languages_;
}
Vector<String> getExpectedInputLanguagesOr(const Vector<String>& fallback_value) const;
Vector<String> getExpectedInputLanguagesOr(Vector<String>&& fallback_value) const;
void setExpectedInputLanguages(const Vector<String>& value);
void setExpectedInputLanguages(Vector<String>&& value);

bool hasFormat() const {
  return true;
}
V8SummarizerFormat format() const {
  return member_format_;
}
void setFormat(V8SummarizerFormat value) {
  member_format_ = value;
}
void setFormat(V8SummarizerFormat::Enum value) {
  member_format_ = V8SummarizerFormat(value);
}

bool hasLength() const {
  return true;
}
V8SummarizerLength length() const {
  return member_length_;
}
void setLength(V8SummarizerLength value) {
  member_length_ = value;
}
void setLength(V8SummarizerLength::Enum value) {
  member_length_ = V8SummarizerLength(value);
}

bool hasOutputLanguage() const {
  return has_output_language_;
}
const String& outputLanguage() const {
  DCHECK(hasOutputLanguage());
return member_output_language_;
}
String getOutputLanguageOr(const String& fallback_value) const;
String getOutputLanguageOr(String&& fallback_value) const;
void setOutputLanguage(const String& value);
void setOutputLanguage(String&& value);

bool hasType() const {
  return true;
}
V8SummarizerType type() const {
  return member_type_;
}
void setType(V8SummarizerType value) {
  member_type_ = value;
}
void setType(V8SummarizerType::Enum value) {
  member_type_ = V8SummarizerType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_expected_context_languages_ = false;
bool has_expected_input_languages_ = false;
bool has_output_language_ = false;

Vector<String> member_expected_context_languages_;
Vector<String> member_expected_input_languages_;
V8SummarizerFormat member_format_{V8SummarizerFormat::Enum::kMarkdown};
V8SummarizerLength member_length_{V8SummarizerLength::Enum::kShort};
String member_output_language_;
V8SummarizerType member_type_{V8SummarizerType::Enum::kKeyPoints};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUMMARIZER_CREATE_CORE_OPTIONS_H_
