// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUBSAMPLE_ENTRY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUBSAMPLE_ENTRY_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SubsampleEntry : public bindings::InputDictionaryBase {
  
  public:
static SubsampleEntry* Create() {
  return MakeGarbageCollected<SubsampleEntry>();
}
static SubsampleEntry* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SubsampleEntry>(isolate);
}
static SubsampleEntry* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SubsampleEntry();
explicit  SubsampleEntry(v8::Isolate* isolate);

bool hasClearBytes() const {
  return true;
}
uint32_t clearBytes() const {
  return member_clear_bytes_;
}
void setClearBytes(uint32_t value) {
  member_clear_bytes_ = value;
}

bool hasCypherBytes() const {
  return true;
}
uint32_t cypherBytes() const {
  return member_cypher_bytes_;
}
void setCypherBytes(uint32_t value) {
  member_cypher_bytes_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_clear_bytes_;
uint32_t member_cypher_bytes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUBSAMPLE_ENTRY_H_
