// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_USAGE_DETAILS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_USAGE_DETAILS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT StorageUsageDetails : public bindings::DictionaryBase {
  
  public:
static StorageUsageDetails* Create() {
  return MakeGarbageCollected<StorageUsageDetails>();
}
static StorageUsageDetails* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StorageUsageDetails>(isolate);
}
static StorageUsageDetails* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StorageUsageDetails();
explicit  StorageUsageDetails(v8::Isolate* isolate);

bool hasCaches() const {
  return has_caches_;
}
uint64_t caches() const {
  DCHECK(hasCaches());
return member_caches_;
}
uint64_t getCachesOr(uint64_t fallback_value) const {
  if (!hasCaches()) {
  return fallback_value;
}
return member_caches_;
}
void setCaches(uint64_t value) {
  member_caches_ = value;
has_caches_ = true;
}

bool hasFileSystem() const {
  return has_file_system_;
}
uint64_t fileSystem() const {
  DCHECK(hasFileSystem());
return member_file_system_;
}
uint64_t getFileSystemOr(uint64_t fallback_value) const {
  if (!hasFileSystem()) {
  return fallback_value;
}
return member_file_system_;
}
void setFileSystem(uint64_t value) {
  member_file_system_ = value;
has_file_system_ = true;
}

bool hasIndexedDB() const {
  return has_indexed_db_;
}
uint64_t indexedDB() const {
  DCHECK(hasIndexedDB());
return member_indexed_db_;
}
uint64_t getIndexedDBOr(uint64_t fallback_value) const {
  if (!hasIndexedDB()) {
  return fallback_value;
}
return member_indexed_db_;
}
void setIndexedDB(uint64_t value) {
  member_indexed_db_ = value;
has_indexed_db_ = true;
}

bool hasServiceWorkerRegistrations() const {
  return has_service_worker_registrations_;
}
uint64_t serviceWorkerRegistrations() const {
  DCHECK(hasServiceWorkerRegistrations());
return member_service_worker_registrations_;
}
uint64_t getServiceWorkerRegistrationsOr(uint64_t fallback_value) const {
  if (!hasServiceWorkerRegistrations()) {
  return fallback_value;
}
return member_service_worker_registrations_;
}
void setServiceWorkerRegistrations(uint64_t value) {
  member_service_worker_registrations_ = value;
has_service_worker_registrations_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_caches_ = false;
bool has_file_system_ = false;
bool has_indexed_db_ = false;
bool has_service_worker_registrations_ = false;

uint64_t member_caches_;
uint64_t member_file_system_;
uint64_t member_indexed_db_;
uint64_t member_service_worker_registrations_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_USAGE_DETAILS_H_
