// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_INTEREST_GROUP_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_INTEREST_GROUP_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuctionAd;
class ExceptionState;
class V8UnionAuctionAdOrLongLong;
class ViewOrClickCounts;

class MODULES_EXPORT StorageInterestGroup : public AuctionAdInterestGroup {
  
  public:
static StorageInterestGroup* Create() {
  return MakeGarbageCollected<StorageInterestGroup>();
}
static StorageInterestGroup* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StorageInterestGroup>(isolate);
}
static StorageInterestGroup* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StorageInterestGroup();
explicit  StorageInterestGroup(v8::Isolate* isolate);

bool hasBidCount() const {
  return has_bid_count_;
}
uint64_t bidCount() const {
  DCHECK(hasBidCount());
return member_bid_count_;
}
uint64_t getBidCountOr(uint64_t fallback_value) const {
  if (!hasBidCount()) {
  return fallback_value;
}
return member_bid_count_;
}
void setBidCount(uint64_t value) {
  member_bid_count_ = value;
has_bid_count_ = true;
}

bool hasClickCounts() const {
  return has_click_counts_;
}
ViewOrClickCounts* clickCounts() const {
  DCHECK(hasClickCounts());
return member_click_counts_.Get();
}
ViewOrClickCounts* getClickCountsOr(ViewOrClickCounts* fallback_value) const {
  if (!hasClickCounts()) {
  return fallback_value;
}
return member_click_counts_.Get();
}
void setClickCounts(ViewOrClickCounts* value) {
  member_click_counts_ = value;
has_click_counts_ = true;
DCHECK(member_click_counts_);
}

bool hasEstimatedSize() const {
  return has_estimated_size_;
}
uint64_t estimatedSize() const {
  DCHECK(hasEstimatedSize());
return member_estimated_size_;
}
uint64_t getEstimatedSizeOr(uint64_t fallback_value) const {
  if (!hasEstimatedSize()) {
  return fallback_value;
}
return member_estimated_size_;
}
void setEstimatedSize(uint64_t value) {
  member_estimated_size_ = value;
has_estimated_size_ = true;
}

bool hasJoinCount() const {
  return has_join_count_;
}
uint64_t joinCount() const {
  DCHECK(hasJoinCount());
return member_join_count_;
}
uint64_t getJoinCountOr(uint64_t fallback_value) const {
  if (!hasJoinCount()) {
  return fallback_value;
}
return member_join_count_;
}
void setJoinCount(uint64_t value) {
  member_join_count_ = value;
has_join_count_ = true;
}

bool hasJoiningOrigin() const {
  return has_joining_origin_;
}
const String& joiningOrigin() const {
  DCHECK(hasJoiningOrigin());
return member_joining_origin_;
}
String getJoiningOriginOr(const String& fallback_value) const;
String getJoiningOriginOr(String&& fallback_value) const;
void setJoiningOrigin(const String& value);
void setJoiningOrigin(String&& value);

bool hasLifetimeRemainingMs() const {
  return has_lifetime_remaining_ms_;
}
int64_t lifetimeRemainingMs() const {
  DCHECK(hasLifetimeRemainingMs());
return member_lifetime_remaining_ms_;
}
int64_t getLifetimeRemainingMsOr(int64_t fallback_value) const {
  if (!hasLifetimeRemainingMs()) {
  return fallback_value;
}
return member_lifetime_remaining_ms_;
}
void setLifetimeRemainingMs(int64_t value) {
  member_lifetime_remaining_ms_ = value;
has_lifetime_remaining_ms_ = true;
}

bool hasPrevWinsMs() const {
  return has_prev_wins_ms_;
}
const HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>& prevWinsMs() const {
  DCHECK(hasPrevWinsMs());
return member_prev_wins_ms_;
}
HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>> getPrevWinsMsOr(const HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>& fallback_value) const;
HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>> getPrevWinsMsOr(HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>&& fallback_value) const;
void setPrevWinsMs(const HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>& value);
void setPrevWinsMs(HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>&& value);

bool hasTimeSinceGroupJoinedMs() const {
  return has_time_since_group_joined_ms_;
}
int64_t timeSinceGroupJoinedMs() const {
  DCHECK(hasTimeSinceGroupJoinedMs());
return member_time_since_group_joined_ms_;
}
int64_t getTimeSinceGroupJoinedMsOr(int64_t fallback_value) const {
  if (!hasTimeSinceGroupJoinedMs()) {
  return fallback_value;
}
return member_time_since_group_joined_ms_;
}
void setTimeSinceGroupJoinedMs(int64_t value) {
  member_time_since_group_joined_ms_ = value;
has_time_since_group_joined_ms_ = true;
}

bool hasTimeSinceLastUpdateMs() const {
  return has_time_since_last_update_ms_;
}
int64_t timeSinceLastUpdateMs() const {
  DCHECK(hasTimeSinceLastUpdateMs());
return member_time_since_last_update_ms_;
}
int64_t getTimeSinceLastUpdateMsOr(int64_t fallback_value) const {
  if (!hasTimeSinceLastUpdateMs()) {
  return fallback_value;
}
return member_time_since_last_update_ms_;
}
void setTimeSinceLastUpdateMs(int64_t value) {
  member_time_since_last_update_ms_ = value;
has_time_since_last_update_ms_ = true;
}

bool hasTimeUntilNextUpdateMs() const {
  return has_time_until_next_update_ms_;
}
int64_t timeUntilNextUpdateMs() const {
  DCHECK(hasTimeUntilNextUpdateMs());
return member_time_until_next_update_ms_;
}
int64_t getTimeUntilNextUpdateMsOr(int64_t fallback_value) const {
  if (!hasTimeUntilNextUpdateMs()) {
  return fallback_value;
}
return member_time_until_next_update_ms_;
}
void setTimeUntilNextUpdateMs(int64_t value) {
  member_time_until_next_update_ms_ = value;
has_time_until_next_update_ms_ = true;
}

bool hasViewCounts() const {
  return has_view_counts_;
}
ViewOrClickCounts* viewCounts() const {
  DCHECK(hasViewCounts());
return member_view_counts_.Get();
}
ViewOrClickCounts* getViewCountsOr(ViewOrClickCounts* fallback_value) const {
  if (!hasViewCounts()) {
  return fallback_value;
}
return member_view_counts_.Get();
}
void setViewCounts(ViewOrClickCounts* value) {
  member_view_counts_ = value;
has_view_counts_ = true;
DCHECK(member_view_counts_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AuctionAdInterestGroup::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 11;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bid_count_ = false;
bool has_click_counts_ = false;
bool has_estimated_size_ = false;
bool has_join_count_ = false;
bool has_joining_origin_ = false;
bool has_lifetime_remaining_ms_ = false;
bool has_prev_wins_ms_ = false;
bool has_time_since_group_joined_ms_ = false;
bool has_time_since_last_update_ms_ = false;
bool has_time_until_next_update_ms_ = false;
bool has_view_counts_ = false;

uint64_t member_bid_count_;
Member<ViewOrClickCounts> member_click_counts_;
uint64_t member_estimated_size_;
uint64_t member_join_count_;
String member_joining_origin_;
int64_t member_lifetime_remaining_ms_;
HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>> member_prev_wins_ms_;
int64_t member_time_since_group_joined_ms_;
int64_t member_time_since_last_update_ms_;
int64_t member_time_until_next_update_ms_;
Member<ViewOrClickCounts> member_view_counts_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_INTEREST_GROUP_H_
