// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_interest_group.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_auctionad_longlong.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_view_or_click_counts.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bidCount",
"clickCounts",
"estimatedSize",
"joinCount",
"joiningOrigin",
"lifetimeRemainingMs",
"prevWinsMs",
"timeSinceGroupJoinedMs",
"timeSinceLastUpdateMs",
"timeUntilNextUpdateMs",
"viewCounts",
};


}  // namespace 

StorageInterestGroup* StorageInterestGroup::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  StorageInterestGroup* dictionary = MakeGarbageCollected<StorageInterestGroup>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "StorageInterestGroup";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 StorageInterestGroup::StorageInterestGroup() {
  
}

 StorageInterestGroup::StorageInterestGroup(v8::Isolate* isolate) : AuctionAdInterestGroup(isolate) {
  
}































String StorageInterestGroup::getJoiningOriginOr(const String& fallback_value) const {
  if (!hasJoiningOrigin()) {
  return fallback_value;
}
return member_joining_origin_;
}

String StorageInterestGroup::getJoiningOriginOr(String&& fallback_value) const {
  if (!hasJoiningOrigin()) {
  return std::move(fallback_value);
}
return member_joining_origin_;
}

void StorageInterestGroup::setJoiningOrigin(const String& value) {
  member_joining_origin_ = value;
has_joining_origin_ = true;
}

void StorageInterestGroup::setJoiningOrigin(String&& value) {
  member_joining_origin_ = std::move(value);
has_joining_origin_ = true;
}











HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>> StorageInterestGroup::getPrevWinsMsOr(const HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>& fallback_value) const {
  if (!hasPrevWinsMs()) {
  return fallback_value;
}
return member_prev_wins_ms_;
}

HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>> StorageInterestGroup::getPrevWinsMsOr(HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>&& fallback_value) const {
  if (!hasPrevWinsMs()) {
  return std::move(fallback_value);
}
return member_prev_wins_ms_;
}

void StorageInterestGroup::setPrevWinsMs(const HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>& value) {
  member_prev_wins_ms_ = value;
has_prev_wins_ms_ = true;
}

void StorageInterestGroup::setPrevWinsMs(HeapVector<HeapVector<Member<V8UnionAuctionAdOrLongLong>>>&& value) {
  member_prev_wins_ms_ = std::move(value);
has_prev_wins_ms_ = true;
}
































void StorageInterestGroup::Trace(Visitor* visitor) const {
  visitor->Trace(member_click_counts_);
visitor->Trace(member_prev_wins_ms_);
visitor->Trace(member_view_counts_);
AuctionAdInterestGroup::Trace(visitor);
}

void StorageInterestGroup::FillTemplateProperties(Vector<std::string_view>& properties) const {
  AuctionAdInterestGroup::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void StorageInterestGroup::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  AuctionAdInterestGroup::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBidCount()) {
  values[0] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bid_count_);
DCHECK(!values[0].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeClickinessEnabled()) {
  if (hasClickCounts()) {
  values[1] = ToV8Traits<ViewOrClickCounts>::ToV8(script_state, member_click_counts_.Get());
DCHECK(!values[1].IsEmpty());
}
}
if (hasEstimatedSize()) {
  values[2] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_estimated_size_);
DCHECK(!values[2].IsEmpty());
}
if (hasJoinCount()) {
  values[3] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_join_count_);
DCHECK(!values[3].IsEmpty());
}
if (hasJoiningOrigin()) {
  values[4] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_joining_origin_);
DCHECK(!values[4].IsEmpty());
}
if (hasLifetimeRemainingMs()) {
  values[5] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_lifetime_remaining_ms_);
DCHECK(!values[5].IsEmpty());
}
if (hasPrevWinsMs()) {
  values[6] = ToV8Traits<IDLSequence<IDLSequence<V8UnionAuctionAdOrLongLong>>>::ToV8(script_state, member_prev_wins_ms_);
DCHECK(!values[6].IsEmpty());
}
if (hasTimeSinceGroupJoinedMs()) {
  values[7] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_time_since_group_joined_ms_);
DCHECK(!values[7].IsEmpty());
}
if (hasTimeSinceLastUpdateMs()) {
  values[8] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_time_since_last_update_ms_);
DCHECK(!values[8].IsEmpty());
}
if (hasTimeUntilNextUpdateMs()) {
  values[9] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_time_until_next_update_ms_);
DCHECK(!values[9].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeClickinessEnabled()) {
  if (hasViewCounts()) {
  values[10] = ToV8Traits<ViewOrClickCounts>::ToV8(script_state, member_view_counts_.Get());
DCHECK(!values[10].IsEmpty());
}
}
}

const void* StorageInterestGroup::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> StorageInterestGroup::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void StorageInterestGroup::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
AuctionAdInterestGroup::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "StorageInterestGroup";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bidCount");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_bid_count_, member_bid_count_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeClickinessEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("clickCounts");
if (!bindings::GetDictionaryMemberFromV8Object<ViewOrClickCounts, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_click_counts_, member_click_counts_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("estimatedSize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_estimated_size_, member_estimated_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("joinCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_join_count_, member_join_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("joiningOrigin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_joining_origin_, member_joining_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lifetimeRemainingMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_lifetime_remaining_ms_, member_lifetime_remaining_ms_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("prevWinsMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLSequence<V8UnionAuctionAdOrLongLong>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_prev_wins_ms_, member_prev_wins_ms_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeSinceGroupJoinedMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_time_since_group_joined_ms_, member_time_since_group_joined_ms_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeSinceLastUpdateMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_time_since_last_update_ms_, member_time_since_last_update_ms_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeUntilNextUpdateMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_time_until_next_update_ms_, member_time_until_next_update_ms_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeClickinessEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("viewCounts");
if (!bindings::GetDictionaryMemberFromV8Object<ViewOrClickCounts, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_view_counts_, member_view_counts_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> StorageInterestGroup::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
