// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class StorageArea;

class MODULES_EXPORT StorageEventInit : public EventInit {
  
  public:
static StorageEventInit* Create() {
  return MakeGarbageCollected<StorageEventInit>();
}
static StorageEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StorageEventInit>(isolate);
}
static StorageEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StorageEventInit();
explicit  StorageEventInit(v8::Isolate* isolate);

bool hasKey() const {
  return true;
}
const String& key() const {
  return member_key_;
}
void setKey(const String& value);
void setKey(String&& value);

bool hasNewValue() const {
  return true;
}
const String& newValue() const {
  return member_new_value_;
}
void setNewValue(const String& value);
void setNewValue(String&& value);

bool hasOldValue() const {
  return true;
}
const String& oldValue() const {
  return member_old_value_;
}
void setOldValue(const String& value);
void setOldValue(String&& value);

bool hasStorageArea() const {
  return true;
}
StorageArea* storageArea() const {
  return member_storage_area_.Get();
}
void setStorageArea(StorageArea* value) {
  member_storage_area_ = value;
}

bool hasUrl() const {
  return true;
}
const String& url() const {
  return member_url_;
}
void setUrl(const String& value);
void setUrl(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_key_;
String member_new_value_;
String member_old_value_;
Member<StorageArea> member_storage_area_{nullptr};
String member_url_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_EVENT_INIT_H_
