// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_BUCKET_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_BUCKET_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_bucket_durability.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT StorageBucketOptions : public bindings::InputDictionaryBase {
  
  public:
static StorageBucketOptions* Create() {
  return MakeGarbageCollected<StorageBucketOptions>();
}
static StorageBucketOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StorageBucketOptions>(isolate);
}
static StorageBucketOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StorageBucketOptions();
explicit  StorageBucketOptions(v8::Isolate* isolate);

bool hasDurability() const {
  return has_durability_;
}
V8StorageBucketDurability durability() const {
  DCHECK(hasDurability());
return member_durability_;
}
V8StorageBucketDurability getDurabilityOr(V8StorageBucketDurability fallback_value) const {
  if (!hasDurability()) {
  return fallback_value;
}
return member_durability_;
}
void setDurability(V8StorageBucketDurability value) {
  member_durability_ = value;
has_durability_ = true;
}
void setDurability(V8StorageBucketDurability::Enum value) {
  member_durability_ = V8StorageBucketDurability(value);
has_durability_ = true;
}

bool hasExpires() const {
  return has_expires_;
}
double expires() const {
  DCHECK(hasExpires());
return member_expires_;
}
double getExpiresOr(double fallback_value) const {
  if (!hasExpires()) {
  return fallback_value;
}
return member_expires_;
}
void setExpires(double value) {
  member_expires_ = value;
has_expires_ = true;
}

bool hasPersisted() const {
  return has_persisted_;
}
bool persisted() const {
  DCHECK(hasPersisted());
return member_persisted_;
}
bool getPersistedOr(bool fallback_value) const {
  if (!hasPersisted()) {
  return fallback_value;
}
return member_persisted_;
}
void setPersisted(bool value) {
  member_persisted_ = value;
has_persisted_ = true;
}

bool hasQuota() const {
  return has_quota_;
}
uint64_t quota() const {
  DCHECK(hasQuota());
return member_quota_;
}
uint64_t getQuotaOr(uint64_t fallback_value) const {
  if (!hasQuota()) {
  return fallback_value;
}
return member_quota_;
}
void setQuota(uint64_t value) {
  member_quota_ = value;
has_quota_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_durability_ = false;
bool has_expires_ = false;
bool has_persisted_ = false;
bool has_quota_ = false;

V8StorageBucketDurability member_durability_{static_cast<V8StorageBucketDurability::Enum>(0)};
double member_expires_;
bool member_persisted_;
uint64_t member_quota_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_BUCKET_OPTIONS_H_
