// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_ACCESS_TYPES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_ACCESS_TYPES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT StorageAccessTypes : public bindings::InputDictionaryBase {
  
  public:
static StorageAccessTypes* Create() {
  return MakeGarbageCollected<StorageAccessTypes>();
}
static StorageAccessTypes* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StorageAccessTypes>(isolate);
}
static StorageAccessTypes* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StorageAccessTypes();
explicit  StorageAccessTypes(v8::Isolate* isolate);

bool hasBroadcastChannel() const {
  return true;
}
bool broadcastChannel() const {
  return member_broadcast_channel_;
}
void setBroadcastChannel(bool value) {
  member_broadcast_channel_ = value;
}

bool hasSharedWorker() const {
  return true;
}
bool sharedWorker() const {
  return member_shared_worker_;
}
void setSharedWorker(bool value) {
  member_shared_worker_ = value;
}

bool hasAll() const {
  return true;
}
bool all() const {
  return member_all_;
}
void setAll(bool value) {
  member_all_ = value;
}

bool hasCaches() const {
  return true;
}
bool caches() const {
  return member_caches_;
}
void setCaches(bool value) {
  member_caches_ = value;
}

bool hasCookies() const {
  return true;
}
bool cookies() const {
  return member_cookies_;
}
void setCookies(bool value) {
  member_cookies_ = value;
}

bool hasCreateObjectURL() const {
  return true;
}
bool createObjectURL() const {
  return member_create_object_url_;
}
void setCreateObjectURL(bool value) {
  member_create_object_url_ = value;
}

bool hasEstimate() const {
  return true;
}
bool estimate() const {
  return member_estimate_;
}
void setEstimate(bool value) {
  member_estimate_ = value;
}

bool hasGetDirectory() const {
  return true;
}
bool getDirectory() const {
  return member_get_directory_;
}
void setGetDirectory(bool value) {
  member_get_directory_ = value;
}

bool hasIndexedDB() const {
  return true;
}
bool indexedDB() const {
  return member_indexed_db_;
}
void setIndexedDB(bool value) {
  member_indexed_db_ = value;
}

bool hasLocalStorage() const {
  return true;
}
bool localStorage() const {
  return member_local_storage_;
}
void setLocalStorage(bool value) {
  member_local_storage_ = value;
}

bool hasLocks() const {
  return true;
}
bool locks() const {
  return member_locks_;
}
void setLocks(bool value) {
  member_locks_ = value;
}

bool hasRevokeObjectURL() const {
  return true;
}
bool revokeObjectURL() const {
  return member_revoke_object_url_;
}
void setRevokeObjectURL(bool value) {
  member_revoke_object_url_ = value;
}

bool hasSessionStorage() const {
  return true;
}
bool sessionStorage() const {
  return member_session_storage_;
}
void setSessionStorage(bool value) {
  member_session_storage_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 13;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_broadcast_channel_{false};
bool member_shared_worker_{false};
bool member_all_{false};
bool member_caches_{false};
bool member_cookies_{false};
bool member_create_object_url_{false};
bool member_estimate_{false};
bool member_get_directory_{false};
bool member_indexed_db_{false};
bool member_local_storage_{false};
bool member_locks_{false};
bool member_revoke_object_url_{false};
bool member_session_storage_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_ACCESS_TYPES_H_
