// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_SYNTHESIS_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_SYNTHESIS_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class SpeechSynthesisUtterance;

class MODULES_EXPORT SpeechSynthesisEventInit : public EventInit {
  
  public:
static SpeechSynthesisEventInit* Create() {
  return MakeGarbageCollected<SpeechSynthesisEventInit>();
}
static SpeechSynthesisEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SpeechSynthesisEventInit>(isolate);
}
static SpeechSynthesisEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SpeechSynthesisEventInit();
explicit  SpeechSynthesisEventInit(v8::Isolate* isolate);

bool hasCharIndex() const {
  return true;
}
uint32_t charIndex() const {
  return member_char_index_;
}
void setCharIndex(uint32_t value) {
  member_char_index_ = value;
}

bool hasCharLength() const {
  return true;
}
uint32_t charLength() const {
  return member_char_length_;
}
void setCharLength(uint32_t value) {
  member_char_length_ = value;
}

bool hasElapsedTime() const {
  return true;
}
float elapsedTime() const {
  return member_elapsed_time_;
}
void setElapsedTime(float value) {
  member_elapsed_time_ = value;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);

bool hasUtterance() const {
  return true;
}
SpeechSynthesisUtterance* utterance() const {
  return member_utterance_.Get();
}
void setUtterance(SpeechSynthesisUtterance* value) {
  member_utterance_ = value;
DCHECK(member_utterance_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_char_index_{0};
uint32_t member_char_length_{0};
float member_elapsed_time_{0};
String member_name_{""};
Member<SpeechSynthesisUtterance> member_utterance_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_SYNTHESIS_EVENT_INIT_H_
