// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_RECOGNITION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_RECOGNITION_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class SpeechRecognitionResultList;

class MODULES_EXPORT SpeechRecognitionEventInit : public EventInit {
  
  public:
static SpeechRecognitionEventInit* Create() {
  return MakeGarbageCollected<SpeechRecognitionEventInit>();
}
static SpeechRecognitionEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SpeechRecognitionEventInit>(isolate);
}
static SpeechRecognitionEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SpeechRecognitionEventInit();
explicit  SpeechRecognitionEventInit(v8::Isolate* isolate);

bool hasResultIndex() const {
  return true;
}
uint32_t resultIndex() const {
  return member_result_index_;
}
void setResultIndex(uint32_t value) {
  member_result_index_ = value;
}

bool hasResults() const {
  return has_results_;
}
SpeechRecognitionResultList* results() const {
  DCHECK(hasResults());
return member_results_.Get();
}
SpeechRecognitionResultList* getResultsOr(SpeechRecognitionResultList* fallback_value) const {
  if (!hasResults()) {
  return fallback_value;
}
return member_results_.Get();
}
void setResults(SpeechRecognitionResultList* value) {
  member_results_ = value;
has_results_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_results_ = false;

uint32_t member_result_index_{0};
Member<SpeechRecognitionResultList> member_results_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_RECOGNITION_EVENT_INIT_H_
