// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_CONNECTION_STATUS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_CONNECTION_STATUS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_connection_state.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SmartCardConnectionStatus : public bindings::DictionaryBase {
  
  public:
static SmartCardConnectionStatus* Create() {
  return MakeGarbageCollected<SmartCardConnectionStatus>();
}
static SmartCardConnectionStatus* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SmartCardConnectionStatus>(isolate);
}
static SmartCardConnectionStatus* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SmartCardConnectionStatus();
explicit  SmartCardConnectionStatus(v8::Isolate* isolate);

bool hasAnswerToReset() const {
  return has_answer_to_reset_;
}
DOMArrayBuffer* answerToReset() const {
  DCHECK(hasAnswerToReset());
return member_answer_to_reset_.Get();
}
DOMArrayBuffer* getAnswerToResetOr(DOMArrayBuffer* fallback_value) const {
  if (!hasAnswerToReset()) {
  return fallback_value;
}
return member_answer_to_reset_.Get();
}
void setAnswerToReset(DOMArrayBuffer* value) {
  member_answer_to_reset_ = value;
has_answer_to_reset_ = true;
DCHECK(member_answer_to_reset_);
}

bool hasReaderName() const {
  return true;
}
const String& readerName() const {
  return member_reader_name_;
}
void setReaderName(const String& value);
void setReaderName(String&& value);

bool hasState() const {
  return true;
}
V8SmartCardConnectionState state() const {
  return member_state_;
}
void setState(V8SmartCardConnectionState value) {
  member_state_ = value;
}
void setState(V8SmartCardConnectionState::Enum value) {
  member_state_ = V8SmartCardConnectionState(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_answer_to_reset_ = false;

Member<DOMArrayBuffer> member_answer_to_reset_;
String member_reader_name_;
V8SmartCardConnectionState member_state_{static_cast<V8SmartCardConnectionState::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_CONNECTION_STATUS_H_
