// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_URL_WITH_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_URL_WITH_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SharedStorageUrlWithMetadata : public bindings::InputDictionaryBase {
  
  public:
static SharedStorageUrlWithMetadata* Create() {
  return MakeGarbageCollected<SharedStorageUrlWithMetadata>();
}
static SharedStorageUrlWithMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SharedStorageUrlWithMetadata>(isolate);
}
static SharedStorageUrlWithMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SharedStorageUrlWithMetadata();
explicit  SharedStorageUrlWithMetadata(v8::Isolate* isolate);

bool hasReportingMetadata() const {
  return has_reporting_metadata_;
}
const ScriptObject& reportingMetadata() const {
  DCHECK(hasReportingMetadata());
return member_reporting_metadata_;
}
ScriptObject getReportingMetadataOr(const ScriptObject& fallback_value) const {
  if (!hasReportingMetadata()) {
  return fallback_value;
}
return member_reporting_metadata_;
}
void setReportingMetadata(const ScriptObject& value) {
  member_reporting_metadata_ = value;
has_reporting_metadata_ = true;
}

bool hasUrl() const {
  return true;
}
const String& url() const {
  return member_url_;
}
void setUrl(const String& value);
void setUrl(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_reporting_metadata_ = false;

ScriptObject member_reporting_metadata_;
String member_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_URL_WITH_METADATA_H_
