// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_RUN_OPERATION_METHOD_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_RUN_OPERATION_METHOD_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class SharedStoragePrivateAggregationConfig;

class MODULES_EXPORT SharedStorageRunOperationMethodOptions : public bindings::InputDictionaryBase {
  
  public:
static SharedStorageRunOperationMethodOptions* Create() {
  return MakeGarbageCollected<SharedStorageRunOperationMethodOptions>();
}
static SharedStorageRunOperationMethodOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SharedStorageRunOperationMethodOptions>(isolate);
}
static SharedStorageRunOperationMethodOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SharedStorageRunOperationMethodOptions();
explicit  SharedStorageRunOperationMethodOptions(v8::Isolate* isolate);

bool hasData() const {
  return has_data_;
}
const ScriptObject& data() const {
  DCHECK(hasData());
return member_data_;
}
ScriptObject getDataOr(const ScriptObject& fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_;
}
void setData(const ScriptObject& value) {
  member_data_ = value;
has_data_ = true;
}

bool hasKeepAlive() const {
  return true;
}
bool keepAlive() const {
  return member_keep_alive_;
}
void setKeepAlive(bool value) {
  member_keep_alive_ = value;
}

bool hasPrivateAggregationConfig() const {
  return has_private_aggregation_config_;
}
SharedStoragePrivateAggregationConfig* privateAggregationConfig() const {
  DCHECK(hasPrivateAggregationConfig());
return member_private_aggregation_config_.Get();
}
SharedStoragePrivateAggregationConfig* getPrivateAggregationConfigOr(SharedStoragePrivateAggregationConfig* fallback_value) const {
  if (!hasPrivateAggregationConfig()) {
  return fallback_value;
}
return member_private_aggregation_config_.Get();
}
void setPrivateAggregationConfig(SharedStoragePrivateAggregationConfig* value) {
  member_private_aggregation_config_ = value;
has_private_aggregation_config_ = true;
DCHECK(member_private_aggregation_config_);
}

bool hasResolveToConfig() const {
  return true;
}
bool resolveToConfig() const {
  return member_resolve_to_config_;
}
void setResolveToConfig(bool value) {
  member_resolve_to_config_ = value;
}

bool hasSavedQuery() const {
  return true;
}
const String& savedQuery() const {
  return member_saved_query_;
}
void setSavedQuery(const String& value);
void setSavedQuery(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_ = false;
bool has_private_aggregation_config_ = false;

ScriptObject member_data_;
bool member_keep_alive_{false};
Member<SharedStoragePrivateAggregationConfig> member_private_aggregation_config_;
bool member_resolve_to_config_{false};
String member_saved_query_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_RUN_OPERATION_METHOD_OPTIONS_H_
