// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_shadow_realm_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abort_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abort_signal.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_custom_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_exception.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_error_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_promise_rejection_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_structured_serialize_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_subscriber.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_search_params.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_void_function.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_compression_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_decompression_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder_stream.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/shadow_realm/shadow_realm_global_scope.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



void V8ShadowRealmGlobalScope::Impl::Init() {
  V8ShadowRealmGlobalScope::install_interface_template_func_ = InstallInterfaceTemplate;
V8ShadowRealmGlobalScope::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8ShadowRealmGlobalScope::install_context_independent_props_func_ = InstallContextIndependentProperties;
}

namespace  {

namespace v8_shadow_realm_global_scope {


void IsSecureContextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_isSecureContext_Getter");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.isSecureContext.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ShadowRealmGlobalScope* blink_receiver = V8ShadowRealmGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->isSecureContextForBindings(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}


void AbortControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_AbortController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.AbortController");

bindings::V8SetReturnValue(info, V8AbortController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AbortSignalExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_AbortSignal_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.AbortSignal");

bindings::V8SetReturnValue(info, V8AbortSignal::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CompressionStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_CompressionStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.CompressionStream");

bindings::V8SetReturnValue(info, V8CompressionStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CustomEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_CustomEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.CustomEvent");

bindings::V8SetReturnValue(info, V8CustomEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMExceptionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_DOMException_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.DOMException");

bindings::V8SetReturnValue(info, V8DOMException::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DecompressionStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_DecompressionStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.DecompressionStream");

bindings::V8SetReturnValue(info, V8DecompressionStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ErrorEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ErrorEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ErrorEvent");

bindings::V8SetReturnValue(info, V8ErrorEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_Event_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.Event");

bindings::V8SetReturnValue(info, V8Event::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_EventTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.EventTarget");

bindings::V8SetReturnValue(info, V8EventTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ObservableExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_Observable_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.Observable");

bindings::V8SetReturnValue(info, V8Observable::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PromiseRejectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_PromiseRejectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.PromiseRejectionEvent");

bindings::V8SetReturnValue(info, V8PromiseRejectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ShadowRealmGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_ShadowRealmGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.ShadowRealmGlobalScope");

bindings::V8SetReturnValue(info, V8ShadowRealmGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SubscriberExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_Subscriber_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.Subscriber");

bindings::V8SetReturnValue(info, V8Subscriber::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_TextDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.TextDecoder");

bindings::V8SetReturnValue(info, V8TextDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_TextDecoderStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.TextDecoderStream");

bindings::V8SetReturnValue(info, V8TextDecoderStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_TextEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.TextEncoder");

bindings::V8SetReturnValue(info, V8TextEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_TextEncoderStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.TextEncoderStream");

bindings::V8SetReturnValue(info, V8TextEncoderStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_URL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.URL");

bindings::V8SetReturnValue(info, V8URL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLPatternExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_URLPattern_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.URLPattern");

bindings::V8SetReturnValue(info, V8URLPattern::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLSearchParamsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_URLSearchParams_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.URLSearchParams");

bindings::V8SetReturnValue(info, V8URLSearchParams::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AtobOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_atob");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.atob");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ShadowRealmGlobalScope* blink_receiver = V8ShadowRealmGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_atob = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->atob(arg1_atob, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void BtoaOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_btoa");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.btoa");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ShadowRealmGlobalScope* blink_receiver = V8ShadowRealmGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_btoa = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->btoa(arg1_btoa, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void QueueMicrotaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_queueMicrotask");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.queueMicrotask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ShadowRealmGlobalScope* blink_receiver = V8ShadowRealmGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<V8VoidFunction>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_callback;
if (info[0]->IsFunction()) [[likely]] {
  arg1_callback = V8VoidFunction::Create(info[0].As<v8::Function>());
} else {
  ExceptionState exception_state(isolate);
arg1_callback = NativeValueTraits<V8VoidFunction>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->queueMicrotask(arg1_callback);

}

void ReportErrorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_reportError");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.reportError");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ShadowRealmGlobalScope* blink_receiver = V8ShadowRealmGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_e = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->reportError(script_state, arg1_e);

}

void StructuredCloneOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ShadowRealmGlobalScope_structuredClone");
BLINK_BINDINGS_TRACE_EVENT("ShadowRealmGlobalScope.structuredClone");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kStructuredCloneMethod);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ShadowRealmGlobalScope* blink_receiver = V8ShadowRealmGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<StructuredSerializeOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_options;
if (info[1]->IsUndefined()) {
  arg2_options = StructuredSerializeOptions::Create();
} else {
  arg2_options = NativeValueTraits<StructuredSerializeOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->structuredClone(script_state, arg1_value, arg2_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_shadow_realm_global_scope

using namespace v8_shadow_realm_global_scope;

}  // namespace 

void V8ShadowRealmGlobalScope::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8ShadowRealmGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8ShadowRealmGlobalScope::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"isSecureContext", IsSecureContextAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ShadowRealmGlobalScope", kAttributeTable);
}




{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"AbortController", AbortControllerExposedConstructCallback}, 
{"AbortSignal", AbortSignalExposedConstructCallback}, 
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CompressionStream", CompressionStreamExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"CustomEvent", CustomEventExposedConstructCallback}, 
{"DOMException", DOMExceptionExposedConstructCallback}, 
{"DecompressionStream", DecompressionStreamExposedConstructCallback}, 
{"ErrorEvent", ErrorEventExposedConstructCallback}, 
{"Event", EventExposedConstructCallback}, 
{"EventTarget", EventTargetExposedConstructCallback}, 
{"Observable", ObservableExposedConstructCallback}, 
{"PromiseRejectionEvent", PromiseRejectionEventExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"ShadowRealmGlobalScope", ShadowRealmGlobalScopeExposedConstructCallback}, 
{"Subscriber", SubscriberExposedConstructCallback}, 
{"TextDecoder", TextDecoderExposedConstructCallback}, 
{"TextDecoderStream", TextDecoderStreamExposedConstructCallback}, 
{"TextEncoder", TextEncoderExposedConstructCallback}, 
{"TextEncoderStream", TextEncoderStreamExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"URL", URLExposedConstructCallback}, 
{"URLPattern", URLPatternExposedConstructCallback}, 
{"URLSearchParams", URLSearchParamsExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"atob", AtobOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"btoa", BtoaOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"queueMicrotask", QueueMicrotaskOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"reportError", ReportErrorOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"structuredClone", StructuredCloneOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "ShadowRealmGlobalScope", kOperationTable);
}



}

void V8ShadowRealmGlobalScope::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;




if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}



}



}  // namespace blink
