// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_OUTPUT_SIGNALS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_OUTPUT_SIGNALS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SerialOutputSignals : public bindings::InputDictionaryBase {
  
  public:
static SerialOutputSignals* Create() {
  return MakeGarbageCollected<SerialOutputSignals>();
}
static SerialOutputSignals* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SerialOutputSignals>(isolate);
}
static SerialOutputSignals* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SerialOutputSignals();
explicit  SerialOutputSignals(v8::Isolate* isolate);

bool hasBrk() const {
  return has_brk_;
}
bool brk() const {
  DCHECK(hasBrk());
return member_brk_;
}
bool getBrkOr(bool fallback_value) const {
  if (!hasBrk()) {
  return fallback_value;
}
return member_brk_;
}
void setBrk(bool value) {
  member_brk_ = value;
has_brk_ = true;
}

bool hasDataTerminalReady() const {
  return has_data_terminal_ready_;
}
bool dataTerminalReady() const {
  DCHECK(hasDataTerminalReady());
return member_data_terminal_ready_;
}
bool getDataTerminalReadyOr(bool fallback_value) const {
  if (!hasDataTerminalReady()) {
  return fallback_value;
}
return member_data_terminal_ready_;
}
void setDataTerminalReady(bool value) {
  member_data_terminal_ready_ = value;
has_data_terminal_ready_ = true;
}

bool hasRequestToSend() const {
  return has_request_to_send_;
}
bool requestToSend() const {
  DCHECK(hasRequestToSend());
return member_request_to_send_;
}
bool getRequestToSendOr(bool fallback_value) const {
  if (!hasRequestToSend()) {
  return fallback_value;
}
return member_request_to_send_;
}
void setRequestToSend(bool value) {
  member_request_to_send_ = value;
has_request_to_send_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_brk_ = false;
bool has_data_terminal_ready_ = false;
bool has_request_to_send_ = false;

bool member_brk_;
bool member_data_terminal_ready_;
bool member_request_to_send_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_OUTPUT_SIGNALS_H_
