// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bytesReceived",
"bytesSent",
"ccbfMessagesReceived",
"dtlsCipher",
"dtlsRole",
"dtlsState",
"iceLocalUsernameFragment",
"iceRole",
"iceState",
"localCertificateId",
"packetsReceived",
"packetsSent",
"remoteCertificateId",
"rtcpTransportStatsId",
"selectedCandidatePairChanges",
"selectedCandidatePairId",
"srtpCipher",
"tlsVersion",
};


}  // namespace 

RTCTransportStats* RTCTransportStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCTransportStats* dictionary = MakeGarbageCollected<RTCTransportStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCTransportStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCTransportStats::RTCTransportStats() {
  
}

 RTCTransportStats::RTCTransportStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}
























String RTCTransportStats::getDtlsCipherOr(const String& fallback_value) const {
  if (!hasDtlsCipher()) {
  return fallback_value;
}
return member_dtls_cipher_;
}

String RTCTransportStats::getDtlsCipherOr(String&& fallback_value) const {
  if (!hasDtlsCipher()) {
  return std::move(fallback_value);
}
return member_dtls_cipher_;
}

void RTCTransportStats::setDtlsCipher(const String& value) {
  member_dtls_cipher_ = value;
has_dtls_cipher_ = true;
}

void RTCTransportStats::setDtlsCipher(String&& value) {
  member_dtls_cipher_ = std::move(value);
has_dtls_cipher_ = true;
}
















String RTCTransportStats::getIceLocalUsernameFragmentOr(const String& fallback_value) const {
  if (!hasIceLocalUsernameFragment()) {
  return fallback_value;
}
return member_ice_local_username_fragment_;
}

String RTCTransportStats::getIceLocalUsernameFragmentOr(String&& fallback_value) const {
  if (!hasIceLocalUsernameFragment()) {
  return std::move(fallback_value);
}
return member_ice_local_username_fragment_;
}

void RTCTransportStats::setIceLocalUsernameFragment(const String& value) {
  member_ice_local_username_fragment_ = value;
has_ice_local_username_fragment_ = true;
}

void RTCTransportStats::setIceLocalUsernameFragment(String&& value) {
  member_ice_local_username_fragment_ = std::move(value);
has_ice_local_username_fragment_ = true;
}


















String RTCTransportStats::getLocalCertificateIdOr(const String& fallback_value) const {
  if (!hasLocalCertificateId()) {
  return fallback_value;
}
return member_local_certificate_id_;
}

String RTCTransportStats::getLocalCertificateIdOr(String&& fallback_value) const {
  if (!hasLocalCertificateId()) {
  return std::move(fallback_value);
}
return member_local_certificate_id_;
}

void RTCTransportStats::setLocalCertificateId(const String& value) {
  member_local_certificate_id_ = value;
has_local_certificate_id_ = true;
}

void RTCTransportStats::setLocalCertificateId(String&& value) {
  member_local_certificate_id_ = std::move(value);
has_local_certificate_id_ = true;
}


















String RTCTransportStats::getRemoteCertificateIdOr(const String& fallback_value) const {
  if (!hasRemoteCertificateId()) {
  return fallback_value;
}
return member_remote_certificate_id_;
}

String RTCTransportStats::getRemoteCertificateIdOr(String&& fallback_value) const {
  if (!hasRemoteCertificateId()) {
  return std::move(fallback_value);
}
return member_remote_certificate_id_;
}

void RTCTransportStats::setRemoteCertificateId(const String& value) {
  member_remote_certificate_id_ = value;
has_remote_certificate_id_ = true;
}

void RTCTransportStats::setRemoteCertificateId(String&& value) {
  member_remote_certificate_id_ = std::move(value);
has_remote_certificate_id_ = true;
}




String RTCTransportStats::getRtcpTransportStatsIdOr(const String& fallback_value) const {
  if (!hasRtcpTransportStatsId()) {
  return fallback_value;
}
return member_rtcp_transport_stats_id_;
}

String RTCTransportStats::getRtcpTransportStatsIdOr(String&& fallback_value) const {
  if (!hasRtcpTransportStatsId()) {
  return std::move(fallback_value);
}
return member_rtcp_transport_stats_id_;
}

void RTCTransportStats::setRtcpTransportStatsId(const String& value) {
  member_rtcp_transport_stats_id_ = value;
has_rtcp_transport_stats_id_ = true;
}

void RTCTransportStats::setRtcpTransportStatsId(String&& value) {
  member_rtcp_transport_stats_id_ = std::move(value);
has_rtcp_transport_stats_id_ = true;
}











String RTCTransportStats::getSelectedCandidatePairIdOr(const String& fallback_value) const {
  if (!hasSelectedCandidatePairId()) {
  return fallback_value;
}
return member_selected_candidate_pair_id_;
}

String RTCTransportStats::getSelectedCandidatePairIdOr(String&& fallback_value) const {
  if (!hasSelectedCandidatePairId()) {
  return std::move(fallback_value);
}
return member_selected_candidate_pair_id_;
}

void RTCTransportStats::setSelectedCandidatePairId(const String& value) {
  member_selected_candidate_pair_id_ = value;
has_selected_candidate_pair_id_ = true;
}

void RTCTransportStats::setSelectedCandidatePairId(String&& value) {
  member_selected_candidate_pair_id_ = std::move(value);
has_selected_candidate_pair_id_ = true;
}




String RTCTransportStats::getSrtpCipherOr(const String& fallback_value) const {
  if (!hasSrtpCipher()) {
  return fallback_value;
}
return member_srtp_cipher_;
}

String RTCTransportStats::getSrtpCipherOr(String&& fallback_value) const {
  if (!hasSrtpCipher()) {
  return std::move(fallback_value);
}
return member_srtp_cipher_;
}

void RTCTransportStats::setSrtpCipher(const String& value) {
  member_srtp_cipher_ = value;
has_srtp_cipher_ = true;
}

void RTCTransportStats::setSrtpCipher(String&& value) {
  member_srtp_cipher_ = std::move(value);
has_srtp_cipher_ = true;
}




String RTCTransportStats::getTlsVersionOr(const String& fallback_value) const {
  if (!hasTlsVersion()) {
  return fallback_value;
}
return member_tls_version_;
}

String RTCTransportStats::getTlsVersionOr(String&& fallback_value) const {
  if (!hasTlsVersion()) {
  return std::move(fallback_value);
}
return member_tls_version_;
}

void RTCTransportStats::setTlsVersion(const String& value) {
  member_tls_version_ = value;
has_tls_version_ = true;
}

void RTCTransportStats::setTlsVersion(String&& value) {
  member_tls_version_ = std::move(value);
has_tls_version_ = true;
}




void RTCTransportStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCTransportStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCTransportStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBytesReceived()) {
  values[0] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_received_);
DCHECK(!values[0].IsEmpty());
}
if (hasBytesSent()) {
  values[1] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_sent_);
DCHECK(!values[1].IsEmpty());
}
if (hasCcbfMessagesReceived()) {
  values[2] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_ccbf_messages_received_);
DCHECK(!values[2].IsEmpty());
}
if (hasDtlsCipher()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_dtls_cipher_);
DCHECK(!values[3].IsEmpty());
}
if (hasDtlsRole()) {
  values[4] = ToV8Traits<V8RTCDtlsRole>::ToV8(script_state, member_dtls_role_);
DCHECK(!values[4].IsEmpty());
}
if (hasDtlsState()) {
  values[5] = ToV8Traits<V8RTCDtlsTransportState>::ToV8(script_state, member_dtls_state_);
DCHECK(!values[5].IsEmpty());
}
if (hasIceLocalUsernameFragment()) {
  values[6] = ToV8Traits<IDLString>::ToV8(script_state, member_ice_local_username_fragment_);
DCHECK(!values[6].IsEmpty());
}
if (hasIceRole()) {
  values[7] = ToV8Traits<V8RTCIceRole>::ToV8(script_state, member_ice_role_);
DCHECK(!values[7].IsEmpty());
}
if (hasIceState()) {
  values[8] = ToV8Traits<V8RTCIceTransportState>::ToV8(script_state, member_ice_state_);
DCHECK(!values[8].IsEmpty());
}
if (hasLocalCertificateId()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_local_certificate_id_);
DCHECK(!values[9].IsEmpty());
}
if (hasPacketsReceived()) {
  values[10] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_received_);
DCHECK(!values[10].IsEmpty());
}
if (hasPacketsSent()) {
  values[11] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_sent_);
DCHECK(!values[11].IsEmpty());
}
if (hasRemoteCertificateId()) {
  values[12] = ToV8Traits<IDLString>::ToV8(script_state, member_remote_certificate_id_);
DCHECK(!values[12].IsEmpty());
}
if (hasRtcpTransportStatsId()) {
  values[13] = ToV8Traits<IDLString>::ToV8(script_state, member_rtcp_transport_stats_id_);
DCHECK(!values[13].IsEmpty());
}
if (hasSelectedCandidatePairChanges()) {
  values[14] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_selected_candidate_pair_changes_);
DCHECK(!values[14].IsEmpty());
}
if (hasSelectedCandidatePairId()) {
  values[15] = ToV8Traits<IDLString>::ToV8(script_state, member_selected_candidate_pair_id_);
DCHECK(!values[15].IsEmpty());
}
if (hasSrtpCipher()) {
  values[16] = ToV8Traits<IDLString>::ToV8(script_state, member_srtp_cipher_);
DCHECK(!values[16].IsEmpty());
}
if (hasTlsVersion()) {
  values[17] = ToV8Traits<IDLString>::ToV8(script_state, member_tls_version_);
DCHECK(!values[17].IsEmpty());
}
}

const void* RTCTransportStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCTransportStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCTransportStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCTransportStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bytesReceived");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_bytes_received_, member_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_bytes_sent_, member_bytes_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ccbfMessagesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_ccbf_messages_received_, member_ccbf_messages_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dtlsCipher");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_dtls_cipher_, member_dtls_cipher_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dtlsRole");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCDtlsRole, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_dtls_role_, member_dtls_role_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dtlsState");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCDtlsTransportState, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_dtls_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceLocalUsernameFragment");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_ice_local_username_fragment_, member_ice_local_username_fragment_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceRole");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceRole, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_ice_role_, member_ice_role_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceState");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceTransportState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_ice_state_, member_ice_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("localCertificateId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_local_certificate_id_, member_local_certificate_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_packets_received_, member_packets_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_packets_sent_, member_packets_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteCertificateId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_remote_certificate_id_, member_remote_certificate_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rtcpTransportStatsId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_rtcp_transport_stats_id_, member_rtcp_transport_stats_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("selectedCandidatePairChanges");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_selected_candidate_pair_changes_, member_selected_candidate_pair_changes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("selectedCandidatePairId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_selected_candidate_pair_id_, member_selected_candidate_pair_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("srtpCipher");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_srtp_cipher_, member_srtp_cipher_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tlsVersion");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_tls_version_, member_tls_version_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCTransportStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
