// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_ICE_CANDIDATE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_ICE_CANDIDATE_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_candidate_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RtcTransportICECandidateInit : public bindings::InputDictionaryBase {
  
  public:
static RtcTransportICECandidateInit* Create() {
  return MakeGarbageCollected<RtcTransportICECandidateInit>();
}
static RtcTransportICECandidateInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RtcTransportICECandidateInit>(isolate);
}
static RtcTransportICECandidateInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RtcTransportICECandidateInit();
explicit  RtcTransportICECandidateInit(v8::Isolate* isolate);

bool hasAddress() const {
  return has_address_;
}
const String& address() const {
  DCHECK(hasAddress());
return member_address_;
}
String getAddressOr(const String& fallback_value) const;
String getAddressOr(String&& fallback_value) const;
void setAddress(const String& value);
void setAddress(String&& value);

bool hasPassword() const {
  return has_password_;
}
const String& password() const {
  DCHECK(hasPassword());
return member_password_;
}
String getPasswordOr(const String& fallback_value) const;
String getPasswordOr(String&& fallback_value) const;
void setPassword(const String& value);
void setPassword(String&& value);

bool hasPort() const {
  return has_port_;
}
uint16_t port() const {
  DCHECK(hasPort());
return member_port_;
}
uint16_t getPortOr(uint16_t fallback_value) const {
  if (!hasPort()) {
  return fallback_value;
}
return member_port_;
}
void setPort(uint16_t value) {
  member_port_ = value;
has_port_ = true;
}

bool hasType() const {
  return has_type_;
}
V8RTCIceCandidateType type() const {
  DCHECK(hasType());
return member_type_;
}
V8RTCIceCandidateType getTypeOr(V8RTCIceCandidateType fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}
void setType(V8RTCIceCandidateType value) {
  member_type_ = value;
has_type_ = true;
}
void setType(V8RTCIceCandidateType::Enum value) {
  member_type_ = V8RTCIceCandidateType(value);
has_type_ = true;
}

bool hasUsernameFragment() const {
  return has_username_fragment_;
}
const String& usernameFragment() const {
  DCHECK(hasUsernameFragment());
return member_username_fragment_;
}
String getUsernameFragmentOr(const String& fallback_value) const;
String getUsernameFragmentOr(String&& fallback_value) const;
void setUsernameFragment(const String& value);
void setUsernameFragment(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_address_ = false;
bool has_password_ = false;
bool has_port_ = false;
bool has_type_ = false;
bool has_username_fragment_ = false;

String member_address_;
String member_password_;
uint16_t member_port_;
V8RTCIceCandidateType member_type_{static_cast<V8RTCIceCandidateType::Enum>(0)};
String member_username_fragment_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_ICE_CANDIDATE_INIT_H_
