// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_stream_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"codecId",
"kind",
"mediaType",
"ssrc",
"transportId",
};


}  // namespace 

RTCRtpStreamStats* RTCRtpStreamStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRtpStreamStats* dictionary = MakeGarbageCollected<RTCRtpStreamStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRtpStreamStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRtpStreamStats::RTCRtpStreamStats() {
  
}

 RTCRtpStreamStats::RTCRtpStreamStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}



String RTCRtpStreamStats::getCodecIdOr(const String& fallback_value) const {
  if (!hasCodecId()) {
  return fallback_value;
}
return member_codec_id_;
}

String RTCRtpStreamStats::getCodecIdOr(String&& fallback_value) const {
  if (!hasCodecId()) {
  return std::move(fallback_value);
}
return member_codec_id_;
}

void RTCRtpStreamStats::setCodecId(const String& value) {
  member_codec_id_ = value;
has_codec_id_ = true;
}

void RTCRtpStreamStats::setCodecId(String&& value) {
  member_codec_id_ = std::move(value);
has_codec_id_ = true;
}




void RTCRtpStreamStats::setKind(const String& value) {
  member_kind_ = value;
}

void RTCRtpStreamStats::setKind(String&& value) {
  member_kind_ = std::move(value);
}




String RTCRtpStreamStats::getMediaTypeOr(const String& fallback_value) const {
  if (!hasMediaType()) {
  return fallback_value;
}
return member_media_type_;
}

String RTCRtpStreamStats::getMediaTypeOr(String&& fallback_value) const {
  if (!hasMediaType()) {
  return std::move(fallback_value);
}
return member_media_type_;
}

void RTCRtpStreamStats::setMediaType(const String& value) {
  member_media_type_ = value;
has_media_type_ = true;
}

void RTCRtpStreamStats::setMediaType(String&& value) {
  member_media_type_ = std::move(value);
has_media_type_ = true;
}









String RTCRtpStreamStats::getTransportIdOr(const String& fallback_value) const {
  if (!hasTransportId()) {
  return fallback_value;
}
return member_transport_id_;
}

String RTCRtpStreamStats::getTransportIdOr(String&& fallback_value) const {
  if (!hasTransportId()) {
  return std::move(fallback_value);
}
return member_transport_id_;
}

void RTCRtpStreamStats::setTransportId(const String& value) {
  member_transport_id_ = value;
has_transport_id_ = true;
}

void RTCRtpStreamStats::setTransportId(String&& value) {
  member_transport_id_ = std::move(value);
has_transport_id_ = true;
}




void RTCRtpStreamStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCRtpStreamStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRtpStreamStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCodecId()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_codec_id_);
DCHECK(!values[0].IsEmpty());
}
if (hasKind()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_kind_);
DCHECK(!values[1].IsEmpty());
}
if (hasMediaType()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_media_type_);
DCHECK(!values[2].IsEmpty());
}
if (hasSsrc()) {
  values[3] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_ssrc_);
DCHECK(!values[3].IsEmpty());
}
if (hasTransportId()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_transport_id_);
DCHECK(!values[4].IsEmpty());
}
}

const void* RTCRtpStreamStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRtpStreamStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRtpStreamStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCRtpStreamStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("codecId");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_codec_id_, member_codec_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("kind");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_kind_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_media_type_, member_media_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ssrc");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_ssrc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transportId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_transport_id_, member_transport_id_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRtpStreamStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
