// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_send_parameters.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_encoding_parameters.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"degradationPreference",
"encodings",
"transactionId",
};


}  // namespace 

RTCRtpSendParameters* RTCRtpSendParameters::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRtpSendParameters* dictionary = MakeGarbageCollected<RTCRtpSendParameters>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRtpSendParameters";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRtpSendParameters::RTCRtpSendParameters() {
  
}

 RTCRtpSendParameters::RTCRtpSendParameters(v8::Isolate* isolate) : RTCRtpParameters(isolate) {
  
}










void RTCRtpSendParameters::setEncodings(const HeapVector<Member<RTCRtpEncodingParameters>>& value) {
  member_encodings_ = value;
}

void RTCRtpSendParameters::setEncodings(HeapVector<Member<RTCRtpEncodingParameters>>&& value) {
  member_encodings_ = std::move(value);
}




void RTCRtpSendParameters::setTransactionId(const String& value) {
  member_transaction_id_ = value;
}

void RTCRtpSendParameters::setTransactionId(String&& value) {
  member_transaction_id_ = std::move(value);
}




void RTCRtpSendParameters::Trace(Visitor* visitor) const {
  visitor->Trace(member_encodings_);
RTCRtpParameters::Trace(visitor);
}

void RTCRtpSendParameters::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCRtpParameters::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRtpSendParameters::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCRtpParameters::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDegradationPreference()) {
  values[0] = ToV8Traits<V8RTCDegradationPreference>::ToV8(script_state, member_degradation_preference_);
DCHECK(!values[0].IsEmpty());
}
if (hasEncodings()) {
  values[1] = ToV8Traits<IDLSequence<RTCRtpEncodingParameters>>::ToV8(script_state, member_encodings_);
DCHECK(!values[1].IsEmpty());
}
if (hasTransactionId()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_transaction_id_);
DCHECK(!values[2].IsEmpty());
}
}

const void* RTCRtpSendParameters::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRtpSendParameters::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRtpSendParameters::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCRtpParameters::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCRtpSendParameters";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("degradationPreference");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCDegradationPreference, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_degradation_preference_, member_degradation_preference_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("encodings");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCRtpEncodingParameters>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_encodings_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transactionId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_transaction_id_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRtpSendParameters::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
