// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RTCRtcpParameters;
class RTCRtpCodecParameters;
class RTCRtpHeaderExtensionParameters;

class MODULES_EXPORT RTCRtpParameters : public bindings::DictionaryBase {
  
  public:
static RTCRtpParameters* Create() {
  return MakeGarbageCollected<RTCRtpParameters>();
}
static RTCRtpParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpParameters>(isolate);
}
static RTCRtpParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpParameters();
explicit  RTCRtpParameters(v8::Isolate* isolate);

bool hasCodecs() const {
  return true;
}
const HeapVector<Member<RTCRtpCodecParameters>>& codecs() const {
  return member_codecs_;
}
void setCodecs(const HeapVector<Member<RTCRtpCodecParameters>>& value);
void setCodecs(HeapVector<Member<RTCRtpCodecParameters>>&& value);

bool hasHeaderExtensions() const {
  return true;
}
const HeapVector<Member<RTCRtpHeaderExtensionParameters>>& headerExtensions() const {
  return member_header_extensions_;
}
void setHeaderExtensions(const HeapVector<Member<RTCRtpHeaderExtensionParameters>>& value);
void setHeaderExtensions(HeapVector<Member<RTCRtpHeaderExtensionParameters>>&& value);

bool hasRtcp() const {
  return true;
}
RTCRtcpParameters* rtcp() const {
  return member_rtcp_.Get();
}
void setRtcp(RTCRtcpParameters* value) {
  member_rtcp_ = value;
DCHECK(member_rtcp_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<RTCRtpCodecParameters>> member_codecs_;
HeapVector<Member<RTCRtpHeaderExtensionParameters>> member_header_extensions_;
Member<RTCRtcpParameters> member_rtcp_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_PARAMETERS_H_
