// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RESOLUTION_RESTRICTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RESOLUTION_RESTRICTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCResolutionRestriction : public bindings::DictionaryBase {
  
  public:
static RTCResolutionRestriction* Create() {
  return MakeGarbageCollected<RTCResolutionRestriction>();
}
static RTCResolutionRestriction* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCResolutionRestriction>(isolate);
}
static RTCResolutionRestriction* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCResolutionRestriction();
explicit  RTCResolutionRestriction(v8::Isolate* isolate);

bool hasMaxHeight() const {
  return has_max_height_;
}
uint32_t maxHeight() const {
  DCHECK(hasMaxHeight());
return member_max_height_;
}
uint32_t getMaxHeightOr(uint32_t fallback_value) const {
  if (!hasMaxHeight()) {
  return fallback_value;
}
return member_max_height_;
}
void setMaxHeight(uint32_t value) {
  member_max_height_ = value;
has_max_height_ = true;
}

bool hasMaxWidth() const {
  return has_max_width_;
}
uint32_t maxWidth() const {
  DCHECK(hasMaxWidth());
return member_max_width_;
}
uint32_t getMaxWidthOr(uint32_t fallback_value) const {
  if (!hasMaxWidth()) {
  return fallback_value;
}
return member_max_width_;
}
void setMaxWidth(uint32_t value) {
  member_max_width_ = value;
has_max_width_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_max_height_ = false;
bool has_max_width_ = false;

uint32_t member_max_height_;
uint32_t member_max_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RESOLUTION_RESTRICTION_H_
