// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_REMOTE_INBOUND_RTP_STREAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_REMOTE_INBOUND_RTP_STREAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_received_rtp_stream_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCRemoteInboundRtpStreamStats : public RTCReceivedRtpStreamStats {
  
  public:
static RTCRemoteInboundRtpStreamStats* Create() {
  return MakeGarbageCollected<RTCRemoteInboundRtpStreamStats>();
}
static RTCRemoteInboundRtpStreamStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRemoteInboundRtpStreamStats>(isolate);
}
static RTCRemoteInboundRtpStreamStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRemoteInboundRtpStreamStats();
explicit  RTCRemoteInboundRtpStreamStats(v8::Isolate* isolate);

bool hasFractionLost() const {
  return has_fraction_lost_;
}
double fractionLost() const {
  DCHECK(hasFractionLost());
return member_fraction_lost_;
}
double getFractionLostOr(double fallback_value) const {
  if (!hasFractionLost()) {
  return fallback_value;
}
return member_fraction_lost_;
}
void setFractionLost(double value) {
  member_fraction_lost_ = value;
has_fraction_lost_ = true;
}

bool hasLocalId() const {
  return has_local_id_;
}
const String& localId() const {
  DCHECK(hasLocalId());
return member_local_id_;
}
String getLocalIdOr(const String& fallback_value) const;
String getLocalIdOr(String&& fallback_value) const;
void setLocalId(const String& value);
void setLocalId(String&& value);

bool hasRoundTripTime() const {
  return has_round_trip_time_;
}
double roundTripTime() const {
  DCHECK(hasRoundTripTime());
return member_round_trip_time_;
}
double getRoundTripTimeOr(double fallback_value) const {
  if (!hasRoundTripTime()) {
  return fallback_value;
}
return member_round_trip_time_;
}
void setRoundTripTime(double value) {
  member_round_trip_time_ = value;
has_round_trip_time_ = true;
}

bool hasRoundTripTimeMeasurements() const {
  return has_round_trip_time_measurements_;
}
uint64_t roundTripTimeMeasurements() const {
  DCHECK(hasRoundTripTimeMeasurements());
return member_round_trip_time_measurements_;
}
uint64_t getRoundTripTimeMeasurementsOr(uint64_t fallback_value) const {
  if (!hasRoundTripTimeMeasurements()) {
  return fallback_value;
}
return member_round_trip_time_measurements_;
}
void setRoundTripTimeMeasurements(uint64_t value) {
  member_round_trip_time_measurements_ = value;
has_round_trip_time_measurements_ = true;
}

bool hasTotalRoundTripTime() const {
  return has_total_round_trip_time_;
}
double totalRoundTripTime() const {
  DCHECK(hasTotalRoundTripTime());
return member_total_round_trip_time_;
}
double getTotalRoundTripTimeOr(double fallback_value) const {
  if (!hasTotalRoundTripTime()) {
  return fallback_value;
}
return member_total_round_trip_time_;
}
void setTotalRoundTripTime(double value) {
  member_total_round_trip_time_ = value;
has_total_round_trip_time_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCReceivedRtpStreamStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_fraction_lost_ = false;
bool has_local_id_ = false;
bool has_round_trip_time_ = false;
bool has_round_trip_time_measurements_ = false;
bool has_total_round_trip_time_ = false;

double member_fraction_lost_;
String member_local_id_;
double member_round_trip_time_;
uint64_t member_round_trip_time_measurements_;
double member_total_round_trip_time_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_REMOTE_INBOUND_RTP_STREAM_STATS_H_
