// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_PEER_CONNECTION_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_PEER_CONNECTION_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCPeerConnectionStats : public RTCStats {
  
  public:
static RTCPeerConnectionStats* Create() {
  return MakeGarbageCollected<RTCPeerConnectionStats>();
}
static RTCPeerConnectionStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCPeerConnectionStats>(isolate);
}
static RTCPeerConnectionStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCPeerConnectionStats();
explicit  RTCPeerConnectionStats(v8::Isolate* isolate);

bool hasDataChannelsClosed() const {
  return has_data_channels_closed_;
}
uint32_t dataChannelsClosed() const {
  DCHECK(hasDataChannelsClosed());
return member_data_channels_closed_;
}
uint32_t getDataChannelsClosedOr(uint32_t fallback_value) const {
  if (!hasDataChannelsClosed()) {
  return fallback_value;
}
return member_data_channels_closed_;
}
void setDataChannelsClosed(uint32_t value) {
  member_data_channels_closed_ = value;
has_data_channels_closed_ = true;
}

bool hasDataChannelsOpened() const {
  return has_data_channels_opened_;
}
uint32_t dataChannelsOpened() const {
  DCHECK(hasDataChannelsOpened());
return member_data_channels_opened_;
}
uint32_t getDataChannelsOpenedOr(uint32_t fallback_value) const {
  if (!hasDataChannelsOpened()) {
  return fallback_value;
}
return member_data_channels_opened_;
}
void setDataChannelsOpened(uint32_t value) {
  member_data_channels_opened_ = value;
has_data_channels_opened_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_channels_closed_ = false;
bool has_data_channels_opened_ = false;

uint32_t member_data_channels_closed_;
uint32_t member_data_channels_opened_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_PEER_CONNECTION_STATS_H_
