// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_PEER_CONNECTION_ICE_ERROR_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_PEER_CONNECTION_ICE_ERROR_EVENT_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCPeerConnectionIceErrorEventInit : public EventInit {
  
  public:
static RTCPeerConnectionIceErrorEventInit* Create() {
  return MakeGarbageCollected<RTCPeerConnectionIceErrorEventInit>();
}
static RTCPeerConnectionIceErrorEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCPeerConnectionIceErrorEventInit>(isolate);
}
static RTCPeerConnectionIceErrorEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCPeerConnectionIceErrorEventInit();
explicit  RTCPeerConnectionIceErrorEventInit(v8::Isolate* isolate);

bool hasAddress() const {
  return has_address_;
}
const String& address() const {
  DCHECK(hasAddress());
return member_address_;
}
String getAddressOr(const String& fallback_value) const;
String getAddressOr(String&& fallback_value) const;
void setAddress(const String& value);
void setAddress(String&& value);

bool hasErrorCode() const {
  return true;
}
uint16_t errorCode() const {
  return member_error_code_;
}
void setErrorCode(uint16_t value) {
  member_error_code_ = value;
}

bool hasErrorText() const {
  return has_error_text_;
}
const String& errorText() const {
  DCHECK(hasErrorText());
return member_error_text_;
}
String getErrorTextOr(const String& fallback_value) const;
String getErrorTextOr(String&& fallback_value) const;
void setErrorText(const String& value);
void setErrorText(String&& value);

bool hasHostCandidate() const {
  return has_host_candidate_;
}
const String& hostCandidate() const {
  DCHECK(hasHostCandidate());
return member_host_candidate_;
}
String getHostCandidateOr(const String& fallback_value) const;
String getHostCandidateOr(String&& fallback_value) const;
void setHostCandidate(const String& value);
void setHostCandidate(String&& value);

bool hasPort() const {
  return has_port_;
}
const std::optional<uint16_t>& port() const {
  DCHECK(hasPort());
return member_port_;
}
std::optional<uint16_t> getPortOr(const std::optional<uint16_t>& fallback_value) const {
  if (!hasPort()) {
  return fallback_value;
}
return member_port_;
}
void setPort(const std::optional<uint16_t>& value) {
  member_port_ = value;
has_port_ = true;
}
void setPort(uint16_t value) {
  member_port_ = value;
has_port_ = true;
}

bool hasUrl() const {
  return has_url_;
}
const String& url() const {
  DCHECK(hasUrl());
return member_url_;
}
String getUrlOr(const String& fallback_value) const;
String getUrlOr(String&& fallback_value) const;
void setUrl(const String& value);
void setUrl(String&& value);


// Obsolete accessor functions
bool hasPortNonNull() const {
  return hasPort() && port().has_value();
}
uint16_t portNonNull() const {
  DCHECK(hasPortNonNull());
return port().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_address_ = false;
bool has_error_text_ = false;
bool has_host_candidate_ = false;
bool has_port_ = false;
bool has_url_ = false;

String member_address_;
uint16_t member_error_code_;
String member_error_text_;
String member_host_candidate_;
std::optional<uint16_t> member_port_;
String member_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_PEER_CONNECTION_ICE_ERROR_EVENT_INIT_H_
