// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_outbound_rtp_stream_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"active",
"contentType",
"encoderImplementation",
"encodingIndex",
"firCount",
"frameHeight",
"frameWidth",
"framesEncoded",
"framesPerSecond",
"framesSent",
"headerBytesSent",
"hugeFramesSent",
"keyFramesEncoded",
"mediaSourceId",
"mid",
"nackCount",
"packetsSentWithEct1",
"pliCount",
"powerEfficientEncoder",
"psnrMeasurements",
"psnrSum",
"qpSum",
"qualityLimitationDurations",
"qualityLimitationReason",
"qualityLimitationResolutionChanges",
"remoteId",
"retransmittedBytesSent",
"retransmittedPacketsSent",
"rid",
"rtxSsrc",
"scalabilityMode",
"targetBitrate",
"totalEncodeTime",
"totalEncodedBytesTarget",
"totalPacketSendDelay",
};


}  // namespace 

RTCOutboundRtpStreamStats* RTCOutboundRtpStreamStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCOutboundRtpStreamStats* dictionary = MakeGarbageCollected<RTCOutboundRtpStreamStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCOutboundRtpStreamStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCOutboundRtpStreamStats::RTCOutboundRtpStreamStats() {
  
}

 RTCOutboundRtpStreamStats::RTCOutboundRtpStreamStats(v8::Isolate* isolate) : RTCSentRtpStreamStats(isolate) {
  
}










String RTCOutboundRtpStreamStats::getContentTypeOr(const String& fallback_value) const {
  if (!hasContentType()) {
  return fallback_value;
}
return member_content_type_;
}

String RTCOutboundRtpStreamStats::getContentTypeOr(String&& fallback_value) const {
  if (!hasContentType()) {
  return std::move(fallback_value);
}
return member_content_type_;
}

void RTCOutboundRtpStreamStats::setContentType(const String& value) {
  member_content_type_ = value;
has_content_type_ = true;
}

void RTCOutboundRtpStreamStats::setContentType(String&& value) {
  member_content_type_ = std::move(value);
has_content_type_ = true;
}




String RTCOutboundRtpStreamStats::getEncoderImplementationOr(const String& fallback_value) const {
  if (!hasEncoderImplementation()) {
  return fallback_value;
}
return member_encoder_implementation_;
}

String RTCOutboundRtpStreamStats::getEncoderImplementationOr(String&& fallback_value) const {
  if (!hasEncoderImplementation()) {
  return std::move(fallback_value);
}
return member_encoder_implementation_;
}

void RTCOutboundRtpStreamStats::setEncoderImplementation(const String& value) {
  member_encoder_implementation_ = value;
has_encoder_implementation_ = true;
}

void RTCOutboundRtpStreamStats::setEncoderImplementation(String&& value) {
  member_encoder_implementation_ = std::move(value);
has_encoder_implementation_ = true;
}










































































String RTCOutboundRtpStreamStats::getMediaSourceIdOr(const String& fallback_value) const {
  if (!hasMediaSourceId()) {
  return fallback_value;
}
return member_media_source_id_;
}

String RTCOutboundRtpStreamStats::getMediaSourceIdOr(String&& fallback_value) const {
  if (!hasMediaSourceId()) {
  return std::move(fallback_value);
}
return member_media_source_id_;
}

void RTCOutboundRtpStreamStats::setMediaSourceId(const String& value) {
  member_media_source_id_ = value;
has_media_source_id_ = true;
}

void RTCOutboundRtpStreamStats::setMediaSourceId(String&& value) {
  member_media_source_id_ = std::move(value);
has_media_source_id_ = true;
}




String RTCOutboundRtpStreamStats::getMidOr(const String& fallback_value) const {
  if (!hasMid()) {
  return fallback_value;
}
return member_mid_;
}

String RTCOutboundRtpStreamStats::getMidOr(String&& fallback_value) const {
  if (!hasMid()) {
  return std::move(fallback_value);
}
return member_mid_;
}

void RTCOutboundRtpStreamStats::setMid(const String& value) {
  member_mid_ = value;
has_mid_ = true;
}

void RTCOutboundRtpStreamStats::setMid(String&& value) {
  member_mid_ = std::move(value);
has_mid_ = true;
}







































Vector<std::pair<String, double>> RTCOutboundRtpStreamStats::getPsnrSumOr(const Vector<std::pair<String, double>>& fallback_value) const {
  if (!hasPsnrSum()) {
  return fallback_value;
}
return member_psnr_sum_;
}

Vector<std::pair<String, double>> RTCOutboundRtpStreamStats::getPsnrSumOr(Vector<std::pair<String, double>>&& fallback_value) const {
  if (!hasPsnrSum()) {
  return std::move(fallback_value);
}
return member_psnr_sum_;
}

void RTCOutboundRtpStreamStats::setPsnrSum(const Vector<std::pair<String, double>>& value) {
  member_psnr_sum_ = value;
has_psnr_sum_ = true;
}

void RTCOutboundRtpStreamStats::setPsnrSum(Vector<std::pair<String, double>>&& value) {
  member_psnr_sum_ = std::move(value);
has_psnr_sum_ = true;
}











Vector<std::pair<String, double>> RTCOutboundRtpStreamStats::getQualityLimitationDurationsOr(const Vector<std::pair<String, double>>& fallback_value) const {
  if (!hasQualityLimitationDurations()) {
  return fallback_value;
}
return member_quality_limitation_durations_;
}

Vector<std::pair<String, double>> RTCOutboundRtpStreamStats::getQualityLimitationDurationsOr(Vector<std::pair<String, double>>&& fallback_value) const {
  if (!hasQualityLimitationDurations()) {
  return std::move(fallback_value);
}
return member_quality_limitation_durations_;
}

void RTCOutboundRtpStreamStats::setQualityLimitationDurations(const Vector<std::pair<String, double>>& value) {
  member_quality_limitation_durations_ = value;
has_quality_limitation_durations_ = true;
}

void RTCOutboundRtpStreamStats::setQualityLimitationDurations(Vector<std::pair<String, double>>&& value) {
  member_quality_limitation_durations_ = std::move(value);
has_quality_limitation_durations_ = true;
}


















String RTCOutboundRtpStreamStats::getRemoteIdOr(const String& fallback_value) const {
  if (!hasRemoteId()) {
  return fallback_value;
}
return member_remote_id_;
}

String RTCOutboundRtpStreamStats::getRemoteIdOr(String&& fallback_value) const {
  if (!hasRemoteId()) {
  return std::move(fallback_value);
}
return member_remote_id_;
}

void RTCOutboundRtpStreamStats::setRemoteId(const String& value) {
  member_remote_id_ = value;
has_remote_id_ = true;
}

void RTCOutboundRtpStreamStats::setRemoteId(String&& value) {
  member_remote_id_ = std::move(value);
has_remote_id_ = true;
}


















String RTCOutboundRtpStreamStats::getRidOr(const String& fallback_value) const {
  if (!hasRid()) {
  return fallback_value;
}
return member_rid_;
}

String RTCOutboundRtpStreamStats::getRidOr(String&& fallback_value) const {
  if (!hasRid()) {
  return std::move(fallback_value);
}
return member_rid_;
}

void RTCOutboundRtpStreamStats::setRid(const String& value) {
  member_rid_ = value;
has_rid_ = true;
}

void RTCOutboundRtpStreamStats::setRid(String&& value) {
  member_rid_ = std::move(value);
has_rid_ = true;
}











String RTCOutboundRtpStreamStats::getScalabilityModeOr(const String& fallback_value) const {
  if (!hasScalabilityMode()) {
  return fallback_value;
}
return member_scalability_mode_;
}

String RTCOutboundRtpStreamStats::getScalabilityModeOr(String&& fallback_value) const {
  if (!hasScalabilityMode()) {
  return std::move(fallback_value);
}
return member_scalability_mode_;
}

void RTCOutboundRtpStreamStats::setScalabilityMode(const String& value) {
  member_scalability_mode_ = value;
has_scalability_mode_ = true;
}

void RTCOutboundRtpStreamStats::setScalabilityMode(String&& value) {
  member_scalability_mode_ = std::move(value);
has_scalability_mode_ = true;
}
































void RTCOutboundRtpStreamStats::Trace(Visitor* visitor) const {
  RTCSentRtpStreamStats::Trace(visitor);
}

void RTCOutboundRtpStreamStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCSentRtpStreamStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCOutboundRtpStreamStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCSentRtpStreamStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasActive()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_active_);
DCHECK(!values[0].IsEmpty());
}
if (hasContentType()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_content_type_);
DCHECK(!values[1].IsEmpty());
}
if (hasEncoderImplementation()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_encoder_implementation_);
DCHECK(!values[2].IsEmpty());
}
if (hasEncodingIndex()) {
  values[3] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_encoding_index_);
DCHECK(!values[3].IsEmpty());
}
if (hasFirCount()) {
  values[4] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_fir_count_);
DCHECK(!values[4].IsEmpty());
}
if (hasFrameHeight()) {
  values[5] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frame_height_);
DCHECK(!values[5].IsEmpty());
}
if (hasFrameWidth()) {
  values[6] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frame_width_);
DCHECK(!values[6].IsEmpty());
}
if (hasFramesEncoded()) {
  values[7] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frames_encoded_);
DCHECK(!values[7].IsEmpty());
}
if (hasFramesPerSecond()) {
  values[8] = ToV8Traits<IDLDouble>::ToV8(script_state, member_frames_per_second_);
DCHECK(!values[8].IsEmpty());
}
if (hasFramesSent()) {
  values[9] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frames_sent_);
DCHECK(!values[9].IsEmpty());
}
if (hasHeaderBytesSent()) {
  values[10] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_header_bytes_sent_);
DCHECK(!values[10].IsEmpty());
}
if (hasHugeFramesSent()) {
  values[11] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_huge_frames_sent_);
DCHECK(!values[11].IsEmpty());
}
if (hasKeyFramesEncoded()) {
  values[12] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_key_frames_encoded_);
DCHECK(!values[12].IsEmpty());
}
if (hasMediaSourceId()) {
  values[13] = ToV8Traits<IDLString>::ToV8(script_state, member_media_source_id_);
DCHECK(!values[13].IsEmpty());
}
if (hasMid()) {
  values[14] = ToV8Traits<IDLString>::ToV8(script_state, member_mid_);
DCHECK(!values[14].IsEmpty());
}
if (hasNackCount()) {
  values[15] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_nack_count_);
DCHECK(!values[15].IsEmpty());
}
if (hasPacketsSentWithEct1()) {
  values[16] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_sent_with_ect_1_);
DCHECK(!values[16].IsEmpty());
}
if (hasPliCount()) {
  values[17] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_pli_count_);
DCHECK(!values[17].IsEmpty());
}
if (hasPowerEfficientEncoder()) {
  values[18] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_power_efficient_encoder_);
DCHECK(!values[18].IsEmpty());
}
if (hasPsnrMeasurements()) {
  values[19] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_psnr_measurements_);
DCHECK(!values[19].IsEmpty());
}
if (hasPsnrSum()) {
  values[20] = ToV8Traits<IDLRecord<IDLString, IDLDouble>>::ToV8(script_state, member_psnr_sum_);
DCHECK(!values[20].IsEmpty());
}
if (hasQpSum()) {
  values[21] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_qp_sum_);
DCHECK(!values[21].IsEmpty());
}
if (hasQualityLimitationDurations()) {
  values[22] = ToV8Traits<IDLRecord<IDLString, IDLDouble>>::ToV8(script_state, member_quality_limitation_durations_);
DCHECK(!values[22].IsEmpty());
}
if (hasQualityLimitationReason()) {
  values[23] = ToV8Traits<V8RTCQualityLimitationReason>::ToV8(script_state, member_quality_limitation_reason_);
DCHECK(!values[23].IsEmpty());
}
if (hasQualityLimitationResolutionChanges()) {
  values[24] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_quality_limitation_resolution_changes_);
DCHECK(!values[24].IsEmpty());
}
if (hasRemoteId()) {
  values[25] = ToV8Traits<IDLString>::ToV8(script_state, member_remote_id_);
DCHECK(!values[25].IsEmpty());
}
if (hasRetransmittedBytesSent()) {
  values[26] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_retransmitted_bytes_sent_);
DCHECK(!values[26].IsEmpty());
}
if (hasRetransmittedPacketsSent()) {
  values[27] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_retransmitted_packets_sent_);
DCHECK(!values[27].IsEmpty());
}
if (hasRid()) {
  values[28] = ToV8Traits<IDLString>::ToV8(script_state, member_rid_);
DCHECK(!values[28].IsEmpty());
}
if (hasRtxSsrc()) {
  values[29] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_rtx_ssrc_);
DCHECK(!values[29].IsEmpty());
}
if (hasScalabilityMode()) {
  values[30] = ToV8Traits<IDLString>::ToV8(script_state, member_scalability_mode_);
DCHECK(!values[30].IsEmpty());
}
if (hasTargetBitrate()) {
  values[31] = ToV8Traits<IDLDouble>::ToV8(script_state, member_target_bitrate_);
DCHECK(!values[31].IsEmpty());
}
if (hasTotalEncodeTime()) {
  values[32] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_encode_time_);
DCHECK(!values[32].IsEmpty());
}
if (hasTotalEncodedBytesTarget()) {
  values[33] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_total_encoded_bytes_target_);
DCHECK(!values[33].IsEmpty());
}
if (hasTotalPacketSendDelay()) {
  values[34] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_packet_send_delay_);
DCHECK(!values[34].IsEmpty());
}
}

const void* RTCOutboundRtpStreamStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCOutboundRtpStreamStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCOutboundRtpStreamStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCSentRtpStreamStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCOutboundRtpStreamStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("active");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_active_, member_active_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contentType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_content_type_, member_content_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("encoderImplementation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_encoder_implementation_, member_encoder_implementation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("encodingIndex");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_encoding_index_, member_encoding_index_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("firCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_fir_count_, member_fir_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameHeight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_frame_height_, member_frame_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_frame_width_, member_frame_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesEncoded");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_frames_encoded_, member_frames_encoded_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesPerSecond");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_frames_per_second_, member_frames_per_second_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_frames_sent_, member_frames_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("headerBytesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_header_bytes_sent_, member_header_bytes_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hugeFramesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_huge_frames_sent_, member_huge_frames_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keyFramesEncoded");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_key_frames_encoded_, member_key_frames_encoded_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaSourceId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_media_source_id_, member_media_source_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mid");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_mid_, member_mid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("nackCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_nack_count_, member_nack_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsSentWithEct1");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_packets_sent_with_ect_1_, member_packets_sent_with_ect_1_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pliCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_pli_count_, member_pli_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("powerEfficientEncoder");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_power_efficient_encoder_, member_power_efficient_encoder_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("psnrMeasurements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_psnr_measurements_, member_psnr_measurements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("psnrSum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_psnr_sum_, member_psnr_sum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("qpSum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_qp_sum_, member_qp_sum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("qualityLimitationDurations");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_quality_limitation_durations_, member_quality_limitation_durations_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("qualityLimitationReason");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCQualityLimitationReason, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_quality_limitation_reason_, member_quality_limitation_reason_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("qualityLimitationResolutionChanges");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_quality_limitation_resolution_changes_, member_quality_limitation_resolution_changes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_remote_id_, member_remote_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retransmittedBytesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_retransmitted_bytes_sent_, member_retransmitted_bytes_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retransmittedPacketsSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_retransmitted_packets_sent_, member_retransmitted_packets_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rid");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_rid_, member_rid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rtxSsrc");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_rtx_ssrc_, member_rtx_ssrc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("scalabilityMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_scalability_mode_, member_scalability_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("targetBitrate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), has_target_bitrate_, member_target_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalEncodeTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), has_total_encode_time_, member_total_encode_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalEncodedBytesTarget");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_total_encoded_bytes_target_, member_total_encoded_bytes_target_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalPacketSendDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_total_packet_send_delay_, member_total_packet_send_delay_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCOutboundRtpStreamStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
