// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_inbound_rtp_stream_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"audioLevel",
"bytesReceived",
"concealedSamples",
"concealmentEvents",
"contentType",
"corruptionMeasurements",
"decoderImplementation",
"estimatedPlayoutTimestamp",
"fecBytesReceived",
"fecPacketsDiscarded",
"fecPacketsReceived",
"fecSsrc",
"firCount",
"frameHeight",
"frameWidth",
"framesAssembledFromMultiplePackets",
"framesDecoded",
"framesDropped",
"framesPerSecond",
"framesReceived",
"freezeCount",
"googTimingFrameInfo",
"headerBytesReceived",
"insertedSamplesForDeceleration",
"jitterBufferDelay",
"jitterBufferEmittedCount",
"jitterBufferMinimumDelay",
"jitterBufferTargetDelay",
"keyFramesDecoded",
"lastPacketReceivedTimestamp",
"mid",
"nackCount",
"packetsDiscarded",
"pauseCount",
"playoutId",
"pliCount",
"powerEfficientDecoder",
"qpSum",
"remoteId",
"removedSamplesForAcceleration",
"retransmittedBytesReceived",
"retransmittedPacketsReceived",
"rtxSsrc",
"silentConcealedSamples",
"totalAssemblyTime",
"totalAudioEnergy",
"totalCorruptionProbability",
"totalDecodeTime",
"totalFreezesDuration",
"totalInterFrameDelay",
"totalPausesDuration",
"totalProcessingDelay",
"totalSamplesDuration",
"totalSamplesReceived",
"totalSquaredCorruptionProbability",
"totalSquaredInterFrameDelay",
"trackIdentifier",
};


}  // namespace 

RTCInboundRtpStreamStats* RTCInboundRtpStreamStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCInboundRtpStreamStats* dictionary = MakeGarbageCollected<RTCInboundRtpStreamStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCInboundRtpStreamStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCInboundRtpStreamStats::RTCInboundRtpStreamStats() {
  
}

 RTCInboundRtpStreamStats::RTCInboundRtpStreamStats(v8::Isolate* isolate) : RTCReceivedRtpStreamStats(isolate) {
  
}































String RTCInboundRtpStreamStats::getContentTypeOr(const String& fallback_value) const {
  if (!hasContentType()) {
  return fallback_value;
}
return member_content_type_;
}

String RTCInboundRtpStreamStats::getContentTypeOr(String&& fallback_value) const {
  if (!hasContentType()) {
  return std::move(fallback_value);
}
return member_content_type_;
}

void RTCInboundRtpStreamStats::setContentType(const String& value) {
  member_content_type_ = value;
has_content_type_ = true;
}

void RTCInboundRtpStreamStats::setContentType(String&& value) {
  member_content_type_ = std::move(value);
has_content_type_ = true;
}











String RTCInboundRtpStreamStats::getDecoderImplementationOr(const String& fallback_value) const {
  if (!hasDecoderImplementation()) {
  return fallback_value;
}
return member_decoder_implementation_;
}

String RTCInboundRtpStreamStats::getDecoderImplementationOr(String&& fallback_value) const {
  if (!hasDecoderImplementation()) {
  return std::move(fallback_value);
}
return member_decoder_implementation_;
}

void RTCInboundRtpStreamStats::setDecoderImplementation(const String& value) {
  member_decoder_implementation_ = value;
has_decoder_implementation_ = true;
}

void RTCInboundRtpStreamStats::setDecoderImplementation(String&& value) {
  member_decoder_implementation_ = std::move(value);
has_decoder_implementation_ = true;
}






































































































String RTCInboundRtpStreamStats::getGoogTimingFrameInfoOr(const String& fallback_value) const {
  if (!hasGoogTimingFrameInfo()) {
  return fallback_value;
}
return member_goog_timing_frame_info_;
}

String RTCInboundRtpStreamStats::getGoogTimingFrameInfoOr(String&& fallback_value) const {
  if (!hasGoogTimingFrameInfo()) {
  return std::move(fallback_value);
}
return member_goog_timing_frame_info_;
}

void RTCInboundRtpStreamStats::setGoogTimingFrameInfo(const String& value) {
  member_goog_timing_frame_info_ = value;
has_goog_timing_frame_info_ = true;
}

void RTCInboundRtpStreamStats::setGoogTimingFrameInfo(String&& value) {
  member_goog_timing_frame_info_ = std::move(value);
has_goog_timing_frame_info_ = true;
}




























































String RTCInboundRtpStreamStats::getMidOr(const String& fallback_value) const {
  if (!hasMid()) {
  return fallback_value;
}
return member_mid_;
}

String RTCInboundRtpStreamStats::getMidOr(String&& fallback_value) const {
  if (!hasMid()) {
  return std::move(fallback_value);
}
return member_mid_;
}

void RTCInboundRtpStreamStats::setMid(const String& value) {
  member_mid_ = value;
has_mid_ = true;
}

void RTCInboundRtpStreamStats::setMid(String&& value) {
  member_mid_ = std::move(value);
has_mid_ = true;
}

























String RTCInboundRtpStreamStats::getPlayoutIdOr(const String& fallback_value) const {
  if (!hasPlayoutId()) {
  return fallback_value;
}
return member_playout_id_;
}

String RTCInboundRtpStreamStats::getPlayoutIdOr(String&& fallback_value) const {
  if (!hasPlayoutId()) {
  return std::move(fallback_value);
}
return member_playout_id_;
}

void RTCInboundRtpStreamStats::setPlayoutId(const String& value) {
  member_playout_id_ = value;
has_playout_id_ = true;
}

void RTCInboundRtpStreamStats::setPlayoutId(String&& value) {
  member_playout_id_ = std::move(value);
has_playout_id_ = true;
}

























String RTCInboundRtpStreamStats::getRemoteIdOr(const String& fallback_value) const {
  if (!hasRemoteId()) {
  return fallback_value;
}
return member_remote_id_;
}

String RTCInboundRtpStreamStats::getRemoteIdOr(String&& fallback_value) const {
  if (!hasRemoteId()) {
  return std::move(fallback_value);
}
return member_remote_id_;
}

void RTCInboundRtpStreamStats::setRemoteId(const String& value) {
  member_remote_id_ = value;
has_remote_id_ = true;
}

void RTCInboundRtpStreamStats::setRemoteId(String&& value) {
  member_remote_id_ = std::move(value);
has_remote_id_ = true;
}



























































































































void RTCInboundRtpStreamStats::setTrackIdentifier(const String& value) {
  member_track_identifier_ = value;
}

void RTCInboundRtpStreamStats::setTrackIdentifier(String&& value) {
  member_track_identifier_ = std::move(value);
}




void RTCInboundRtpStreamStats::Trace(Visitor* visitor) const {
  RTCReceivedRtpStreamStats::Trace(visitor);
}

void RTCInboundRtpStreamStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCReceivedRtpStreamStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCInboundRtpStreamStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCReceivedRtpStreamStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAudioLevel()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_audio_level_);
DCHECK(!values[0].IsEmpty());
}
if (hasBytesReceived()) {
  values[1] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_received_);
DCHECK(!values[1].IsEmpty());
}
if (hasConcealedSamples()) {
  values[2] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_concealed_samples_);
DCHECK(!values[2].IsEmpty());
}
if (hasConcealmentEvents()) {
  values[3] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_concealment_events_);
DCHECK(!values[3].IsEmpty());
}
if (hasContentType()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_content_type_);
DCHECK(!values[4].IsEmpty());
}
if (hasCorruptionMeasurements()) {
  values[5] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_corruption_measurements_);
DCHECK(!values[5].IsEmpty());
}
if (hasDecoderImplementation()) {
  values[6] = ToV8Traits<IDLString>::ToV8(script_state, member_decoder_implementation_);
DCHECK(!values[6].IsEmpty());
}
if (hasEstimatedPlayoutTimestamp()) {
  values[7] = ToV8Traits<IDLDouble>::ToV8(script_state, member_estimated_playout_timestamp_);
DCHECK(!values[7].IsEmpty());
}
if (hasFecBytesReceived()) {
  values[8] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_fec_bytes_received_);
DCHECK(!values[8].IsEmpty());
}
if (hasFecPacketsDiscarded()) {
  values[9] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_fec_packets_discarded_);
DCHECK(!values[9].IsEmpty());
}
if (hasFecPacketsReceived()) {
  values[10] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_fec_packets_received_);
DCHECK(!values[10].IsEmpty());
}
if (hasFecSsrc()) {
  values[11] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_fec_ssrc_);
DCHECK(!values[11].IsEmpty());
}
if (hasFirCount()) {
  values[12] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_fir_count_);
DCHECK(!values[12].IsEmpty());
}
if (hasFrameHeight()) {
  values[13] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frame_height_);
DCHECK(!values[13].IsEmpty());
}
if (hasFrameWidth()) {
  values[14] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frame_width_);
DCHECK(!values[14].IsEmpty());
}
if (hasFramesAssembledFromMultiplePackets()) {
  values[15] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frames_assembled_from_multiple_packets_);
DCHECK(!values[15].IsEmpty());
}
if (hasFramesDecoded()) {
  values[16] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frames_decoded_);
DCHECK(!values[16].IsEmpty());
}
if (hasFramesDropped()) {
  values[17] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frames_dropped_);
DCHECK(!values[17].IsEmpty());
}
if (hasFramesPerSecond()) {
  values[18] = ToV8Traits<IDLDouble>::ToV8(script_state, member_frames_per_second_);
DCHECK(!values[18].IsEmpty());
}
if (hasFramesReceived()) {
  values[19] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_frames_received_);
DCHECK(!values[19].IsEmpty());
}
if (hasFreezeCount()) {
  values[20] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_freeze_count_);
DCHECK(!values[20].IsEmpty());
}
if (hasGoogTimingFrameInfo()) {
  values[21] = ToV8Traits<IDLString>::ToV8(script_state, member_goog_timing_frame_info_);
DCHECK(!values[21].IsEmpty());
}
if (hasHeaderBytesReceived()) {
  values[22] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_header_bytes_received_);
DCHECK(!values[22].IsEmpty());
}
if (hasInsertedSamplesForDeceleration()) {
  values[23] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_inserted_samples_for_deceleration_);
DCHECK(!values[23].IsEmpty());
}
if (hasJitterBufferDelay()) {
  values[24] = ToV8Traits<IDLDouble>::ToV8(script_state, member_jitter_buffer_delay_);
DCHECK(!values[24].IsEmpty());
}
if (hasJitterBufferEmittedCount()) {
  values[25] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_jitter_buffer_emitted_count_);
DCHECK(!values[25].IsEmpty());
}
if (hasJitterBufferMinimumDelay()) {
  values[26] = ToV8Traits<IDLDouble>::ToV8(script_state, member_jitter_buffer_minimum_delay_);
DCHECK(!values[26].IsEmpty());
}
if (hasJitterBufferTargetDelay()) {
  values[27] = ToV8Traits<IDLDouble>::ToV8(script_state, member_jitter_buffer_target_delay_);
DCHECK(!values[27].IsEmpty());
}
if (hasKeyFramesDecoded()) {
  values[28] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_key_frames_decoded_);
DCHECK(!values[28].IsEmpty());
}
if (hasLastPacketReceivedTimestamp()) {
  values[29] = ToV8Traits<IDLDouble>::ToV8(script_state, member_last_packet_received_timestamp_);
DCHECK(!values[29].IsEmpty());
}
if (hasMid()) {
  values[30] = ToV8Traits<IDLString>::ToV8(script_state, member_mid_);
DCHECK(!values[30].IsEmpty());
}
if (hasNackCount()) {
  values[31] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_nack_count_);
DCHECK(!values[31].IsEmpty());
}
if (hasPacketsDiscarded()) {
  values[32] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_discarded_);
DCHECK(!values[32].IsEmpty());
}
if (hasPauseCount()) {
  values[33] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_pause_count_);
DCHECK(!values[33].IsEmpty());
}
if (hasPlayoutId()) {
  values[34] = ToV8Traits<IDLString>::ToV8(script_state, member_playout_id_);
DCHECK(!values[34].IsEmpty());
}
if (hasPliCount()) {
  values[35] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_pli_count_);
DCHECK(!values[35].IsEmpty());
}
if (hasPowerEfficientDecoder()) {
  values[36] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_power_efficient_decoder_);
DCHECK(!values[36].IsEmpty());
}
if (hasQpSum()) {
  values[37] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_qp_sum_);
DCHECK(!values[37].IsEmpty());
}
if (hasRemoteId()) {
  values[38] = ToV8Traits<IDLString>::ToV8(script_state, member_remote_id_);
DCHECK(!values[38].IsEmpty());
}
if (hasRemovedSamplesForAcceleration()) {
  values[39] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_removed_samples_for_acceleration_);
DCHECK(!values[39].IsEmpty());
}
if (hasRetransmittedBytesReceived()) {
  values[40] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_retransmitted_bytes_received_);
DCHECK(!values[40].IsEmpty());
}
if (hasRetransmittedPacketsReceived()) {
  values[41] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_retransmitted_packets_received_);
DCHECK(!values[41].IsEmpty());
}
if (hasRtxSsrc()) {
  values[42] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_rtx_ssrc_);
DCHECK(!values[42].IsEmpty());
}
if (hasSilentConcealedSamples()) {
  values[43] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_silent_concealed_samples_);
DCHECK(!values[43].IsEmpty());
}
if (hasTotalAssemblyTime()) {
  values[44] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_assembly_time_);
DCHECK(!values[44].IsEmpty());
}
if (hasTotalAudioEnergy()) {
  values[45] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_audio_energy_);
DCHECK(!values[45].IsEmpty());
}
if (hasTotalCorruptionProbability()) {
  values[46] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_corruption_probability_);
DCHECK(!values[46].IsEmpty());
}
if (hasTotalDecodeTime()) {
  values[47] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_decode_time_);
DCHECK(!values[47].IsEmpty());
}
if (hasTotalFreezesDuration()) {
  values[48] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_freezes_duration_);
DCHECK(!values[48].IsEmpty());
}
if (hasTotalInterFrameDelay()) {
  values[49] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_inter_frame_delay_);
DCHECK(!values[49].IsEmpty());
}
if (hasTotalPausesDuration()) {
  values[50] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_pauses_duration_);
DCHECK(!values[50].IsEmpty());
}
if (hasTotalProcessingDelay()) {
  values[51] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_processing_delay_);
DCHECK(!values[51].IsEmpty());
}
if (hasTotalSamplesDuration()) {
  values[52] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_samples_duration_);
DCHECK(!values[52].IsEmpty());
}
if (hasTotalSamplesReceived()) {
  values[53] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_total_samples_received_);
DCHECK(!values[53].IsEmpty());
}
if (hasTotalSquaredCorruptionProbability()) {
  values[54] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_squared_corruption_probability_);
DCHECK(!values[54].IsEmpty());
}
if (hasTotalSquaredInterFrameDelay()) {
  values[55] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_squared_inter_frame_delay_);
DCHECK(!values[55].IsEmpty());
}
if (hasTrackIdentifier()) {
  values[56] = ToV8Traits<IDLString>::ToV8(script_state, member_track_identifier_);
DCHECK(!values[56].IsEmpty());
}
}

const void* RTCInboundRtpStreamStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCInboundRtpStreamStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCInboundRtpStreamStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCReceivedRtpStreamStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCInboundRtpStreamStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("audioLevel");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_audio_level_, member_audio_level_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_bytes_received_, member_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("concealedSamples");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_concealed_samples_, member_concealed_samples_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("concealmentEvents");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_concealment_events_, member_concealment_events_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contentType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_content_type_, member_content_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("corruptionMeasurements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_corruption_measurements_, member_corruption_measurements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("decoderImplementation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_decoder_implementation_, member_decoder_implementation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("estimatedPlayoutTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_estimated_playout_timestamp_, member_estimated_playout_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fecBytesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_fec_bytes_received_, member_fec_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fecPacketsDiscarded");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_fec_packets_discarded_, member_fec_packets_discarded_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fecPacketsReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_fec_packets_received_, member_fec_packets_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fecSsrc");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_fec_ssrc_, member_fec_ssrc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("firCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_fir_count_, member_fir_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameHeight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_frame_height_, member_frame_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_frame_width_, member_frame_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesAssembledFromMultiplePackets");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_frames_assembled_from_multiple_packets_, member_frames_assembled_from_multiple_packets_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesDecoded");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_frames_decoded_, member_frames_decoded_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesDropped");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_frames_dropped_, member_frames_dropped_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesPerSecond");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_frames_per_second_, member_frames_per_second_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_frames_received_, member_frames_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("freezeCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_freeze_count_, member_freeze_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("googTimingFrameInfo");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_goog_timing_frame_info_, member_goog_timing_frame_info_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("headerBytesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_header_bytes_received_, member_header_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("insertedSamplesForDeceleration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_inserted_samples_for_deceleration_, member_inserted_samples_for_deceleration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jitterBufferDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_jitter_buffer_delay_, member_jitter_buffer_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jitterBufferEmittedCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_jitter_buffer_emitted_count_, member_jitter_buffer_emitted_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jitterBufferMinimumDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_jitter_buffer_minimum_delay_, member_jitter_buffer_minimum_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jitterBufferTargetDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_jitter_buffer_target_delay_, member_jitter_buffer_target_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keyFramesDecoded");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_key_frames_decoded_, member_key_frames_decoded_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lastPacketReceivedTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_last_packet_received_timestamp_, member_last_packet_received_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mid");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_mid_, member_mid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("nackCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), has_nack_count_, member_nack_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsDiscarded");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), has_packets_discarded_, member_packets_discarded_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pauseCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_pause_count_, member_pause_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("playoutId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_playout_id_, member_playout_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pliCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), has_pli_count_, member_pli_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("powerEfficientDecoder");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), has_power_efficient_decoder_, member_power_efficient_decoder_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("qpSum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), has_qp_sum_, member_qp_sum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[38].Get(isolate), has_remote_id_, member_remote_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("removedSamplesForAcceleration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[39].Get(isolate), has_removed_samples_for_acceleration_, member_removed_samples_for_acceleration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retransmittedBytesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[40].Get(isolate), has_retransmitted_bytes_received_, member_retransmitted_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retransmittedPacketsReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[41].Get(isolate), has_retransmitted_packets_received_, member_retransmitted_packets_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rtxSsrc");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[42].Get(isolate), has_rtx_ssrc_, member_rtx_ssrc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("silentConcealedSamples");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[43].Get(isolate), has_silent_concealed_samples_, member_silent_concealed_samples_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalAssemblyTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[44].Get(isolate), has_total_assembly_time_, member_total_assembly_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalAudioEnergy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[45].Get(isolate), has_total_audio_energy_, member_total_audio_energy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalCorruptionProbability");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[46].Get(isolate), has_total_corruption_probability_, member_total_corruption_probability_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalDecodeTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[47].Get(isolate), has_total_decode_time_, member_total_decode_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalFreezesDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[48].Get(isolate), has_total_freezes_duration_, member_total_freezes_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalInterFrameDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[49].Get(isolate), has_total_inter_frame_delay_, member_total_inter_frame_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalPausesDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[50].Get(isolate), has_total_pauses_duration_, member_total_pauses_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalProcessingDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[51].Get(isolate), has_total_processing_delay_, member_total_processing_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSamplesDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[52].Get(isolate), has_total_samples_duration_, member_total_samples_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSamplesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[53].Get(isolate), has_total_samples_received_, member_total_samples_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSquaredCorruptionProbability");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[54].Get(isolate), has_total_squared_corruption_probability_, member_total_squared_corruption_probability_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSquaredInterFrameDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[55].Get(isolate), has_total_squared_inter_frame_delay_, member_total_squared_inter_frame_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("trackIdentifier");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[56].Get(isolate), fallback_presence_var, member_track_identifier_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCInboundRtpStreamStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
