// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_candidate_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"address",
"candidateType",
"foundation",
"ip",
"isRemote",
"networkType",
"port",
"priority",
"protocol",
"relatedAddress",
"relatedPort",
"relayProtocol",
"tcpType",
"transportId",
"url",
"usernameFragment",
};


}  // namespace 

RTCIceCandidateStats* RTCIceCandidateStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCIceCandidateStats* dictionary = MakeGarbageCollected<RTCIceCandidateStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCIceCandidateStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCIceCandidateStats::RTCIceCandidateStats() {
  
}

 RTCIceCandidateStats::RTCIceCandidateStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}



String RTCIceCandidateStats::getAddressOr(const String& fallback_value) const {
  if (!hasAddress()) {
  return fallback_value;
}
return member_address_;
}

String RTCIceCandidateStats::getAddressOr(String&& fallback_value) const {
  if (!hasAddress()) {
  return std::move(fallback_value);
}
return member_address_;
}

void RTCIceCandidateStats::setAddress(const String& value) {
  member_address_ = value;
has_address_ = true;
}

void RTCIceCandidateStats::setAddress(String&& value) {
  member_address_ = std::move(value);
has_address_ = true;
}









String RTCIceCandidateStats::getFoundationOr(const String& fallback_value) const {
  if (!hasFoundation()) {
  return fallback_value;
}
return member_foundation_;
}

String RTCIceCandidateStats::getFoundationOr(String&& fallback_value) const {
  if (!hasFoundation()) {
  return std::move(fallback_value);
}
return member_foundation_;
}

void RTCIceCandidateStats::setFoundation(const String& value) {
  member_foundation_ = value;
has_foundation_ = true;
}

void RTCIceCandidateStats::setFoundation(String&& value) {
  member_foundation_ = std::move(value);
has_foundation_ = true;
}




String RTCIceCandidateStats::getIpOr(const String& fallback_value) const {
  if (!hasIp()) {
  return fallback_value;
}
return member_ip_;
}

String RTCIceCandidateStats::getIpOr(String&& fallback_value) const {
  if (!hasIp()) {
  return std::move(fallback_value);
}
return member_ip_;
}

void RTCIceCandidateStats::setIp(const String& value) {
  member_ip_ = value;
has_ip_ = true;
}

void RTCIceCandidateStats::setIp(String&& value) {
  member_ip_ = std::move(value);
has_ip_ = true;
}
































String RTCIceCandidateStats::getProtocolOr(const String& fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_;
}

String RTCIceCandidateStats::getProtocolOr(String&& fallback_value) const {
  if (!hasProtocol()) {
  return std::move(fallback_value);
}
return member_protocol_;
}

void RTCIceCandidateStats::setProtocol(const String& value) {
  member_protocol_ = value;
has_protocol_ = true;
}

void RTCIceCandidateStats::setProtocol(String&& value) {
  member_protocol_ = std::move(value);
has_protocol_ = true;
}




String RTCIceCandidateStats::getRelatedAddressOr(const String& fallback_value) const {
  if (!hasRelatedAddress()) {
  return fallback_value;
}
return member_related_address_;
}

String RTCIceCandidateStats::getRelatedAddressOr(String&& fallback_value) const {
  if (!hasRelatedAddress()) {
  return std::move(fallback_value);
}
return member_related_address_;
}

void RTCIceCandidateStats::setRelatedAddress(const String& value) {
  member_related_address_ = value;
has_related_address_ = true;
}

void RTCIceCandidateStats::setRelatedAddress(String&& value) {
  member_related_address_ = std::move(value);
has_related_address_ = true;
}

























void RTCIceCandidateStats::setTransportId(const String& value) {
  member_transport_id_ = value;
}

void RTCIceCandidateStats::setTransportId(String&& value) {
  member_transport_id_ = std::move(value);
}




String RTCIceCandidateStats::getUrlOr(const String& fallback_value) const {
  if (!hasUrl()) {
  return fallback_value;
}
return member_url_;
}

String RTCIceCandidateStats::getUrlOr(String&& fallback_value) const {
  if (!hasUrl()) {
  return std::move(fallback_value);
}
return member_url_;
}

void RTCIceCandidateStats::setUrl(const String& value) {
  member_url_ = value;
has_url_ = true;
}

void RTCIceCandidateStats::setUrl(String&& value) {
  member_url_ = std::move(value);
has_url_ = true;
}




String RTCIceCandidateStats::getUsernameFragmentOr(const String& fallback_value) const {
  if (!hasUsernameFragment()) {
  return fallback_value;
}
return member_username_fragment_;
}

String RTCIceCandidateStats::getUsernameFragmentOr(String&& fallback_value) const {
  if (!hasUsernameFragment()) {
  return std::move(fallback_value);
}
return member_username_fragment_;
}

void RTCIceCandidateStats::setUsernameFragment(const String& value) {
  member_username_fragment_ = value;
has_username_fragment_ = true;
}

void RTCIceCandidateStats::setUsernameFragment(String&& value) {
  member_username_fragment_ = std::move(value);
has_username_fragment_ = true;
}




void RTCIceCandidateStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCIceCandidateStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCIceCandidateStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAddress()) {
  values[0] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_address_);
DCHECK(!values[0].IsEmpty());
}
if (hasCandidateType()) {
  values[1] = ToV8Traits<V8RTCIceCandidateType>::ToV8(script_state, member_candidate_type_);
DCHECK(!values[1].IsEmpty());
}
if (hasFoundation()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_foundation_);
DCHECK(!values[2].IsEmpty());
}
if (hasIp()) {
  values[3] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_ip_);
DCHECK(!values[3].IsEmpty());
}
if (hasIsRemote()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_remote_);
DCHECK(!values[4].IsEmpty());
}
if (hasNetworkType()) {
  values[5] = ToV8Traits<V8RTCNetworkType>::ToV8(script_state, member_network_type_);
DCHECK(!values[5].IsEmpty());
}
if (hasPort()) {
  values[6] = ToV8Traits<IDLLong>::ToV8(script_state, member_port_);
DCHECK(!values[6].IsEmpty());
}
if (hasPriority()) {
  values[7] = ToV8Traits<IDLLong>::ToV8(script_state, member_priority_);
DCHECK(!values[7].IsEmpty());
}
if (hasProtocol()) {
  values[8] = ToV8Traits<IDLString>::ToV8(script_state, member_protocol_);
DCHECK(!values[8].IsEmpty());
}
if (hasRelatedAddress()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_related_address_);
DCHECK(!values[9].IsEmpty());
}
if (hasRelatedPort()) {
  values[10] = ToV8Traits<IDLLong>::ToV8(script_state, member_related_port_);
DCHECK(!values[10].IsEmpty());
}
if (hasRelayProtocol()) {
  values[11] = ToV8Traits<V8RTCIceServerTransportProtocol>::ToV8(script_state, member_relay_protocol_);
DCHECK(!values[11].IsEmpty());
}
if (hasTcpType()) {
  values[12] = ToV8Traits<V8RTCIceTcpCandidateType>::ToV8(script_state, member_tcp_type_);
DCHECK(!values[12].IsEmpty());
}
if (hasTransportId()) {
  values[13] = ToV8Traits<IDLString>::ToV8(script_state, member_transport_id_);
DCHECK(!values[13].IsEmpty());
}
if (hasUrl()) {
  values[14] = ToV8Traits<IDLString>::ToV8(script_state, member_url_);
DCHECK(!values[14].IsEmpty());
}
if (hasUsernameFragment()) {
  values[15] = ToV8Traits<IDLString>::ToV8(script_state, member_username_fragment_);
DCHECK(!values[15].IsEmpty());
}
}

const void* RTCIceCandidateStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCIceCandidateStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCIceCandidateStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCIceCandidateStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("address");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_address_, member_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("candidateType");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceCandidateType, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_candidate_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("foundation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_foundation_, member_foundation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ip");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_ip_, member_ip_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isRemote");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_is_remote_, member_is_remote_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("networkType");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCNetworkType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_network_type_, member_network_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("port");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_port_, member_port_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("priority");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_priority_, member_priority_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("protocol");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_protocol_, member_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("relatedAddress");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_related_address_, member_related_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("relatedPort");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_related_port_, member_related_port_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("relayProtocol");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceServerTransportProtocol, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_relay_protocol_, member_relay_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tcpType");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceTcpCandidateType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_tcp_type_, member_tcp_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transportId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), fallback_presence_var, member_transport_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("url");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_url_, member_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usernameFragment");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_username_fragment_, member_username_fragment_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCIceCandidateStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
