// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ERROR_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ERROR_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_error_detail_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCErrorInit : public bindings::InputDictionaryBase {
  
  public:
static RTCErrorInit* Create() {
  return MakeGarbageCollected<RTCErrorInit>();
}
static RTCErrorInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCErrorInit>(isolate);
}
static RTCErrorInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCErrorInit();
explicit  RTCErrorInit(v8::Isolate* isolate);

bool hasErrorDetail() const {
  return true;
}
V8RTCErrorDetailType errorDetail() const {
  return member_error_detail_;
}
void setErrorDetail(V8RTCErrorDetailType value) {
  member_error_detail_ = value;
}
void setErrorDetail(V8RTCErrorDetailType::Enum value) {
  member_error_detail_ = V8RTCErrorDetailType(value);
}

bool hasHttpRequestStatusCode() const {
  return has_http_request_status_code_;
}
int32_t httpRequestStatusCode() const {
  DCHECK(hasHttpRequestStatusCode());
return member_http_request_status_code_;
}
int32_t getHttpRequestStatusCodeOr(int32_t fallback_value) const {
  if (!hasHttpRequestStatusCode()) {
  return fallback_value;
}
return member_http_request_status_code_;
}
void setHttpRequestStatusCode(int32_t value) {
  member_http_request_status_code_ = value;
has_http_request_status_code_ = true;
}

bool hasReceivedAlert() const {
  return has_received_alert_;
}
uint32_t receivedAlert() const {
  DCHECK(hasReceivedAlert());
return member_received_alert_;
}
uint32_t getReceivedAlertOr(uint32_t fallback_value) const {
  if (!hasReceivedAlert()) {
  return fallback_value;
}
return member_received_alert_;
}
void setReceivedAlert(uint32_t value) {
  member_received_alert_ = value;
has_received_alert_ = true;
}

bool hasSctpCauseCode() const {
  return has_sctp_cause_code_;
}
int32_t sctpCauseCode() const {
  DCHECK(hasSctpCauseCode());
return member_sctp_cause_code_;
}
int32_t getSctpCauseCodeOr(int32_t fallback_value) const {
  if (!hasSctpCauseCode()) {
  return fallback_value;
}
return member_sctp_cause_code_;
}
void setSctpCauseCode(int32_t value) {
  member_sctp_cause_code_ = value;
has_sctp_cause_code_ = true;
}

bool hasSdpLineNumber() const {
  return has_sdp_line_number_;
}
int32_t sdpLineNumber() const {
  DCHECK(hasSdpLineNumber());
return member_sdp_line_number_;
}
int32_t getSdpLineNumberOr(int32_t fallback_value) const {
  if (!hasSdpLineNumber()) {
  return fallback_value;
}
return member_sdp_line_number_;
}
void setSdpLineNumber(int32_t value) {
  member_sdp_line_number_ = value;
has_sdp_line_number_ = true;
}

bool hasSentAlert() const {
  return has_sent_alert_;
}
uint32_t sentAlert() const {
  DCHECK(hasSentAlert());
return member_sent_alert_;
}
uint32_t getSentAlertOr(uint32_t fallback_value) const {
  if (!hasSentAlert()) {
  return fallback_value;
}
return member_sent_alert_;
}
void setSentAlert(uint32_t value) {
  member_sent_alert_ = value;
has_sent_alert_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_http_request_status_code_ = false;
bool has_received_alert_ = false;
bool has_sctp_cause_code_ = false;
bool has_sdp_line_number_ = false;
bool has_sent_alert_ = false;

V8RTCErrorDetailType member_error_detail_{static_cast<V8RTCErrorDetailType::Enum>(0)};
int32_t member_http_request_status_code_;
uint32_t member_received_alert_;
int32_t member_sctp_cause_code_;
int32_t member_sdp_line_number_;
uint32_t member_sent_alert_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ERROR_INIT_H_
