// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_VIDEO_FRAME_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_VIDEO_FRAME_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_frame_metadata.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCEncodedVideoFrameMetadata : public RTCEncodedFrameMetadata {
  
  public:
static RTCEncodedVideoFrameMetadata* Create() {
  return MakeGarbageCollected<RTCEncodedVideoFrameMetadata>();
}
static RTCEncodedVideoFrameMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCEncodedVideoFrameMetadata>(isolate);
}
static RTCEncodedVideoFrameMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCEncodedVideoFrameMetadata();
explicit  RTCEncodedVideoFrameMetadata(v8::Isolate* isolate);

bool hasDependencies() const {
  return has_dependencies_;
}
const Vector<int64_t>& dependencies() const {
  DCHECK(hasDependencies());
return member_dependencies_;
}
Vector<int64_t> getDependenciesOr(const Vector<int64_t>& fallback_value) const;
Vector<int64_t> getDependenciesOr(Vector<int64_t>&& fallback_value) const;
void setDependencies(const Vector<int64_t>& value);
void setDependencies(Vector<int64_t>&& value);

bool hasFrameId() const {
  return has_frame_id_;
}
int64_t frameId() const {
  DCHECK(hasFrameId());
return member_frame_id_;
}
int64_t getFrameIdOr(int64_t fallback_value) const {
  if (!hasFrameId()) {
  return fallback_value;
}
return member_frame_id_;
}
void setFrameId(int64_t value) {
  member_frame_id_ = value;
has_frame_id_ = true;
}

bool hasHeight() const {
  return has_height_;
}
uint16_t height() const {
  DCHECK(hasHeight());
return member_height_;
}
uint16_t getHeightOr(uint16_t fallback_value) const {
  if (!hasHeight()) {
  return fallback_value;
}
return member_height_;
}
void setHeight(uint16_t value) {
  member_height_ = value;
has_height_ = true;
}

bool hasSpatialIndex() const {
  return has_spatial_index_;
}
uint32_t spatialIndex() const {
  DCHECK(hasSpatialIndex());
return member_spatial_index_;
}
uint32_t getSpatialIndexOr(uint32_t fallback_value) const {
  if (!hasSpatialIndex()) {
  return fallback_value;
}
return member_spatial_index_;
}
void setSpatialIndex(uint32_t value) {
  member_spatial_index_ = value;
has_spatial_index_ = true;
}

bool hasTemporalIndex() const {
  return has_temporal_index_;
}
uint32_t temporalIndex() const {
  DCHECK(hasTemporalIndex());
return member_temporal_index_;
}
uint32_t getTemporalIndexOr(uint32_t fallback_value) const {
  if (!hasTemporalIndex()) {
  return fallback_value;
}
return member_temporal_index_;
}
void setTemporalIndex(uint32_t value) {
  member_temporal_index_ = value;
has_temporal_index_ = true;
}

bool hasTimestamp() const {
  return has_timestamp_;
}
int64_t timestamp() const {
  DCHECK(hasTimestamp());
return member_timestamp_;
}
int64_t getTimestampOr(int64_t fallback_value) const {
  if (!hasTimestamp()) {
  return fallback_value;
}
return member_timestamp_;
}
void setTimestamp(int64_t value) {
  member_timestamp_ = value;
has_timestamp_ = true;
}

bool hasWidth() const {
  return has_width_;
}
uint16_t width() const {
  DCHECK(hasWidth());
return member_width_;
}
uint16_t getWidthOr(uint16_t fallback_value) const {
  if (!hasWidth()) {
  return fallback_value;
}
return member_width_;
}
void setWidth(uint16_t value) {
  member_width_ = value;
has_width_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCEncodedFrameMetadata::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dependencies_ = false;
bool has_frame_id_ = false;
bool has_height_ = false;
bool has_spatial_index_ = false;
bool has_temporal_index_ = false;
bool has_timestamp_ = false;
bool has_width_ = false;

Vector<int64_t> member_dependencies_;
int64_t member_frame_id_;
uint16_t member_height_;
uint32_t member_spatial_index_;
uint32_t member_temporal_index_;
int64_t member_timestamp_;
uint16_t member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_VIDEO_FRAME_METADATA_H_
