// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DTLS_FINGERPRINT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DTLS_FINGERPRINT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCDtlsFingerprint : public bindings::DictionaryBase {
  
  public:
static RTCDtlsFingerprint* Create() {
  return MakeGarbageCollected<RTCDtlsFingerprint>();
}
static RTCDtlsFingerprint* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCDtlsFingerprint>(isolate);
}
static RTCDtlsFingerprint* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCDtlsFingerprint();
explicit  RTCDtlsFingerprint(v8::Isolate* isolate);

bool hasAlgorithm() const {
  return has_algorithm_;
}
const String& algorithm() const {
  DCHECK(hasAlgorithm());
return member_algorithm_;
}
String getAlgorithmOr(const String& fallback_value) const;
String getAlgorithmOr(String&& fallback_value) const;
void setAlgorithm(const String& value);
void setAlgorithm(String&& value);

bool hasValue() const {
  return has_value_;
}
const String& value() const {
  DCHECK(hasValue());
return member_value_;
}
String getValueOr(const String& fallback_value) const;
String getValueOr(String&& fallback_value) const;
void setValue(const String& value);
void setValue(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_algorithm_ = false;
bool has_value_ = false;

String member_algorithm_;
String member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DTLS_FINGERPRINT_H_
