// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_data_channel_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bytesReceived",
"bytesSent",
"dataChannelIdentifier",
"label",
"messagesReceived",
"messagesSent",
"protocol",
"state",
};


}  // namespace 

RTCDataChannelStats* RTCDataChannelStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCDataChannelStats* dictionary = MakeGarbageCollected<RTCDataChannelStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCDataChannelStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCDataChannelStats::RTCDataChannelStats() {
  
}

 RTCDataChannelStats::RTCDataChannelStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}
























String RTCDataChannelStats::getLabelOr(const String& fallback_value) const {
  if (!hasLabel()) {
  return fallback_value;
}
return member_label_;
}

String RTCDataChannelStats::getLabelOr(String&& fallback_value) const {
  if (!hasLabel()) {
  return std::move(fallback_value);
}
return member_label_;
}

void RTCDataChannelStats::setLabel(const String& value) {
  member_label_ = value;
has_label_ = true;
}

void RTCDataChannelStats::setLabel(String&& value) {
  member_label_ = std::move(value);
has_label_ = true;
}


















String RTCDataChannelStats::getProtocolOr(const String& fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_;
}

String RTCDataChannelStats::getProtocolOr(String&& fallback_value) const {
  if (!hasProtocol()) {
  return std::move(fallback_value);
}
return member_protocol_;
}

void RTCDataChannelStats::setProtocol(const String& value) {
  member_protocol_ = value;
has_protocol_ = true;
}

void RTCDataChannelStats::setProtocol(String&& value) {
  member_protocol_ = std::move(value);
has_protocol_ = true;
}









void RTCDataChannelStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCDataChannelStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCDataChannelStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBytesReceived()) {
  values[0] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_received_);
DCHECK(!values[0].IsEmpty());
}
if (hasBytesSent()) {
  values[1] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_sent_);
DCHECK(!values[1].IsEmpty());
}
if (hasDataChannelIdentifier()) {
  values[2] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_data_channel_identifier_);
DCHECK(!values[2].IsEmpty());
}
if (hasLabel()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_label_);
DCHECK(!values[3].IsEmpty());
}
if (hasMessagesReceived()) {
  values[4] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_messages_received_);
DCHECK(!values[4].IsEmpty());
}
if (hasMessagesSent()) {
  values[5] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_messages_sent_);
DCHECK(!values[5].IsEmpty());
}
if (hasProtocol()) {
  values[6] = ToV8Traits<IDLString>::ToV8(script_state, member_protocol_);
DCHECK(!values[6].IsEmpty());
}
if (hasState()) {
  values[7] = ToV8Traits<V8RTCDataChannelState>::ToV8(script_state, member_state_);
DCHECK(!values[7].IsEmpty());
}
}

const void* RTCDataChannelStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCDataChannelStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCDataChannelStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCDataChannelStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bytesReceived");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_bytes_received_, member_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_bytes_sent_, member_bytes_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dataChannelIdentifier");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_data_channel_identifier_, member_data_channel_identifier_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("label");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_label_, member_label_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("messagesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_messages_received_, member_messages_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("messagesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_messages_sent_, member_messages_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("protocol");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_protocol_, member_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("state");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCDataChannelState, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_state_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCDataChannelStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
